Namespace LoadFromString
	Partial Public Class LoadFromStringMain
		Inherits Form
		Private ReadOnly _exception As Boolean

		Public Sub New()
			Try
				InitializeComponent()
			Catch exc As ComponentPro.Licensing.TemplateEngine.UltimateLicenseException
				MessageBox.Show(exc.Message)
				_exception = True
			End Try
		End Sub

		Protected Overrides Sub OnLoad(ByVal e As EventArgs)
			MyBase.OnLoad(e)
			If _exception Then
				Me.Close()
			End If
		End Sub

		Private Sub exitToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles exitToolStripMenuItem.Click
			Me.Close()
		End Sub

		Private Class OrderProduct
			Private _partId As Integer
			Private _productName As String
			Private _quantity As Integer
			Private _price As Single

			Public Property PartId() As Integer
				Get
					Return _partId
				End Get
				Set(ByVal value As Integer)
					_partId = value
				End Set
			End Property

			Public Property ProductName() As String
				Get
					Return _productName
				End Get
				Set(ByVal value As String)
					_productName = value
				End Set
			End Property

			Public Property Quantity() As Integer
				Get
					Return _quantity
				End Get
				Set(ByVal value As Integer)
					_quantity = value
				End Set
			End Property

			Public Property Price() As Single
				Get
					Return _price
				End Get
				Set(ByVal value As Single)
					_price = value
				End Set
			End Property
		End Class

		Private Class User
			Private _fullName As String
			Private _emailAddress As String
			Private _password As String

			Public Property FullName() As String
				Get
					Return _fullName
				End Get
				Set(ByVal value As String)
					_fullName = value
				End Set
			End Property

			Public Property EmailAddress() As String
				Get
					Return _emailAddress
				End Get
				Set(ByVal value As String)
					_emailAddress = value
				End Set
			End Property

			Public Property Password() As String
				Get
					Return _password
				End Get
				Set(ByVal value As String)
					_password = value
				End Set
			End Property

			Public Function GetOrders() As OrderProduct()
				Dim ops(2) As OrderProduct

				ops(0) = New OrderProduct()
				ops(0).PartId = 1239
				ops(0).Price = 104.09F
				ops(0).ProductName = "Product A"
				ops(0).Quantity = 3

				ops(1) = New OrderProduct()
				ops(1).PartId = 22
				ops(1).Price = 134.09F
				ops(1).ProductName = "Product B"
				ops(1).Quantity = 1

				ops(2) = New OrderProduct()
				ops(2).PartId = 167
				ops(2).Price = 14.7F
				ops(2).ProductName = "Product C"
				ops(2).Quantity = 5

				Return ops
			End Function
		End Class

		Private Sub runToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles runToolStripMenuItem.Click
			Try
				dt.LoadFromString(txtSource.Text)
				dt.SetValue("CompanyName", "My Company Name")

				Dim u As New User()
				u.EmailAddress = "myemail@somedomain.com"
				u.FullName = "John Borders"
				u.Password = "123abc"
				dt.SetValue("User", u)
				dt.SetValue("OrderId", "1625DGHJ")

				txtOutput.Text = dt.Run()
			Catch exc As Exception
				MessageBox.Show("An error occurred: " & exc.Message)
			End Try
		End Sub
	End Class
End Namespace