Imports System.IO

Imports Manoli.Utils.CSharpFormat

Namespace AdvancedDemo
	Partial Public Class CodePreview
		Inherits Form
		Private ReadOnly _cs As Boolean
		Private ReadOnly _fileName As String

		Public Sub New()
			InitializeComponent()
		End Sub

		Public Sub New(ByVal fileName As String, ByVal cs As Boolean)
			InitializeComponent()

			Me.Text = System.IO.Path.GetFileName(fileName) & " - Code Preview"
			_cs = cs
			_fileName = fileName

			code.Url = New Uri(AppDomain.CurrentDomain.BaseDirectory & "EmptyCode.template")
			AddHandler code.DocumentCompleted, AddressOf code_DocumentCompleted
		End Sub

		Private Sub code_DocumentCompleted(ByVal sender As Object, ByVal e As WebBrowserDocumentCompletedEventArgs)
			Dim formatter As CodeFormat

			If _cs Then
				formatter = New CSharpFormat()
			Else
				formatter = New VisualBasicFormat()
			End If

			Dim sw As New StreamReader(_fileName)
			Dim formattedCode As String = formatter.FormatCode(sw.BaseStream)
			sw.Close()

			code.Document.Body.InnerHtml = formattedCode
		End Sub
	End Class
End Namespace