using System;
using System.Windows.Forms;
using ComponentPro;

namespace MethodAndPropertyRestriction
{
    public static class MyTestClass
    {
        public static string TestString
        {
            get { return "Static String"; }
        }

        public static string GetStaticString(string s)
        {
            return string.Format("GetStaticString returns {0}", s);
        }
    }

    public static class ClassRestricted
    {
        public static string TestString
        {
            get { return "Test String in a restricted class"; }
        }
    }

    public static class MethodAndProperty
    {
        public static string TestStringRestricted
        {
            get { return "Restricted String"; }
        }

        public static string GetStaticStringRestricted(string s)
        {
            return string.Format("GetStaticStringRestricted returns {0}", s);
        }

        public static string StaticStringAllowed
        {
            get
            {
                return "StaticStringAllowed";
            }
        }
    }

    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main()
        {
            try
            {
                TemplateEngine ctl = new TemplateEngine();
                ctl.LoadFromString("$using(\"MethodAndPropertyRestriction,MethodAndPropertyRestriction\")$$MyTestClass.TestString$\r\n$MyTestClass.GetStaticString(\"Test\")$\r\n$ClassRestricted.TestString$\r\n$MethodAndProperty.TestStringRestricted$\r\n$MethodAndProperty.GetStaticStringRestricted()$\r\n$MethodAndProperty.StaticStringAllowed$");
                ctl.RestrictedMethodList.Add("*.ClassRestricted.*");
                ctl.RestrictedPropertyList.Add("*.ClassRestricted.*");
                ctl.RestrictedMethodList.Add("*.MethodAndProperty.GetStaticString*");
                ctl.AllowedMethodList.Add("*.MethodAndProperty.GetStaticStringAllowed");
                ctl.RestrictedPropertyList.Add("*.TestStringRestricted");
                string s = ctl.Run();
                MessageBox.Show(s);
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message);
            }
        }
    }
}