Imports ComponentPro.Net

Namespace ProxySample
	Friend Class SettingInfo
		#Region "Proxy"

		Private _proxyServer As String
		Public Property ProxyServer() As String
			Get
				Return _proxyServer
			End Get
			Set(ByVal value As String)
				_proxyServer = value
			End Set
		End Property

		Private _proxyPort As Integer
		Public Property ProxyPort() As Integer
			Get
				Return _proxyPort
			End Get
			Set(ByVal value As Integer)
				_proxyPort = value
			End Set
		End Property

		Private _proxyUser As String
		Public Property ProxyUser() As String
			Get
				Return _proxyUser
			End Get
			Set(ByVal value As String)
				_proxyUser = value
			End Set
		End Property

		Private _proxyPassword As String
		Public Property ProxyPassword() As String
			Get
				Return _proxyPassword
			End Get
			Set(ByVal value As String)
				_proxyPassword = value
			End Set
		End Property

		Private _proxyDomain As String
		Public Property ProxyDomain() As String
			Get
				Return _proxyDomain
			End Get
			Set(ByVal value As String)
				_proxyDomain = value
			End Set
		End Property

		Private _proxyType As ProxyType
		Public Property ProxyType() As ProxyType
			Get
				Return _proxyType
			End Get
			Set(ByVal value As ProxyType)
				_proxyType = value
			End Set
		End Property

		Private _proxyMethod As ProxyHttpConnectAuthMethod
		Public Property ProxyMethod() As ProxyHttpConnectAuthMethod
			Get
				Return _proxyMethod
			End Get
			Set(ByVal value As ProxyHttpConnectAuthMethod)
				_proxyMethod = value
			End Set
		End Property

		#End Region

		#Region "Url"

		Private _url As String
		Public Property Url() As String
			Get
				Return _url
			End Get
			Set(ByVal value As String)
				_url = value
			End Set
		End Property

		#End Region

		#Region "Methods"

		Public Sub SaveConfig()
			' Proxy Info.
			Util.SaveProperty("ProxyServer", ProxyServer)
			Util.SaveProperty("ProxyPort", ProxyPort)
			Util.SaveProperty("ProxyUser", ProxyUser)
			Util.SaveProperty("ProxyPassword", ProxyPassword)
			Util.SaveProperty("ProxyDomain", ProxyDomain)
			Util.SaveProperty("ProxyType", CInt(Fix(ProxyType)))
			Util.SaveProperty("ProxyMethod", CInt(Fix(ProxyMethod)))

			' Url.
			Util.SaveProperty("Url", Url)
		End Sub

		Public Shared Function LoadConfig() As SettingInfo
			' Load Login information.
			Dim s As New SettingInfo()

			' Proxy info.
			s.ProxyServer = CStr(Util.GetProperty("ProxyServer", String.Empty))
			s.ProxyPort = Util.GetIntProperty("ProxyPort", 1080)
			s.ProxyUser = CStr(Util.GetProperty("ProxyUser", String.Empty))
			s.ProxyPassword = CStr(Util.GetProperty("ProxyPassword", String.Empty))
			s.ProxyDomain = CStr(Util.GetProperty("ProxyDomain", String.Empty))
			s.ProxyType = CType(Util.GetIntProperty("ProxyType", 0), ProxyType)
			s.ProxyMethod = CType(Util.GetIntProperty("ProxyMethod", 0), ProxyHttpConnectAuthMethod)

			' Url.
			s.Url = CStr(Util.GetProperty("Url", "http://www.yahoo.com"))

			Return s
		End Function

		#End Region
	End Class
End Namespace
