using ComponentPro.Net;

namespace ProxySample
{
    class SettingInfo
    {
        #region Proxy

        string _proxyServer;
        public string ProxyServer
        {
            get { return _proxyServer; }
            set { _proxyServer = value; }
        }

        int _proxyPort;
        public int ProxyPort
        {
            get { return _proxyPort; }
            set { _proxyPort = value; }
        }

        string _proxyUser;
        public string ProxyUser
        {
            get { return _proxyUser; }
            set { _proxyUser = value; }
        }

        string _proxyPassword;
        public string ProxyPassword
        {
            get { return _proxyPassword; }
            set { _proxyPassword = value; }
        }

        string _proxyDomain;
        public string ProxyDomain
        {
            get { return _proxyDomain; }
            set { _proxyDomain = value; }
        }

        ProxyType _proxyType;
        public ProxyType ProxyType
        {
            get { return _proxyType; }
            set { _proxyType = value; }
        }

        ProxyHttpConnectAuthMethod _proxyMethod;
        public ProxyHttpConnectAuthMethod ProxyMethod
        {
            get { return _proxyMethod; }
            set { _proxyMethod = value; }
        }

        #endregion

        #region Host

        int _port;
        public int Port
        {
            get { return _port; }
            set { _port = value; }
        }

        string _host;
        public string Host
        {
            get { return _host; }
            set { _host = value; }
        }

        #endregion

        #region Methods

        public void SaveConfig()
        {
            // Proxy Info.
            Util.SaveProperty("ProxyServer", ProxyServer);
            Util.SaveProperty("ProxyPort", ProxyPort);
            Util.SaveProperty("ProxyType", (int)ProxyType);
            Util.SaveProperty("ProxyUser", ProxyUser);
            Util.SaveProperty("ProxyPassword", ProxyPassword);
            Util.SaveProperty("ProxyDomain", ProxyDomain);
            Util.SaveProperty("ProxyMethod", (int)ProxyMethod);

            // Host.
            Util.SaveProperty("Port", Port);
            Util.SaveProperty("Host", Host);
        }

        public static SettingInfo LoadConfig()
        {
            // Load Login information.
            SettingInfo s = new SettingInfo();

            // Proxy info.
            s.ProxyServer = (string)Util.GetProperty("ProxyServer", string.Empty);
            s.ProxyPort = Util.GetIntProperty("ProxyPort", 1080);
            s.ProxyType = (ProxyType)Util.GetIntProperty("ProxyType", 0);
            s.ProxyUser = (string)Util.GetProperty("ProxyUser", string.Empty);
            s.ProxyPassword = (string)Util.GetProperty("ProxyPassword", string.Empty);
            s.ProxyDomain = (string)Util.GetProperty("ProxyDomain", string.Empty);
            s.ProxyMethod = (ProxyHttpConnectAuthMethod)Util.GetIntProperty("ProxyMethod", 0);

            // Host.
            s.Port = Util.GetIntProperty("Port", 80);
            s.Host = (string)Util.GetProperty("Host", "www.yahoo.com");

            return s;
        }

        #endregion
    }
}