using System;
using System.IO;
using ComponentPro.Net;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }
    
    /// <summary>
    /// Handles the Send button's Click event.
    /// </summary>
    /// <param name="sender">The button object.</param>
    /// <param name="e">The event arguments.</param>
    protected void btn_Click(object sender, EventArgs e)
    {
        try
        {
            // Construct request message to send to the destination host.
            string requestMessage =
                    "GET / HTTP/1.0\r\n" +
                    "Host: " + txtHostName.Text + "\r\n" +
                    "Connection: close\r\n" +
                    "\r\n";

            int proxyPort;
            if (txtProxyPort.Text.Trim().Length == 0)
                proxyPort = 1080;
            else
                proxyPort = int.Parse(txtProxyPort.Text);

            // Create a new instance of the ProxyClient and connect to the host address.
            using (ProxyClient proxyClient = new ProxyClient(txtHostName.Text, int.Parse(txtPort.Text), (ProxyType)ddlProxyType.SelectedIndex, ddlMethod.SelectedIndex == 0 ? ProxyHttpConnectAuthMethod.Basic : ProxyHttpConnectAuthMethod.Ntlm,
                txtProxyServer.Text, proxyPort, txtUserName.Text, txtPassword.Text, txtDomain.Text))
            {
                // Send the request message.
                StreamWriter streamWriter = new StreamWriter(proxyClient.GetStream());
                streamWriter.Write(requestMessage);
                streamWriter.Flush();

                // And read response.
                StreamReader streamReader = new StreamReader(proxyClient.GetStream());
                txtOutput.Text = streamReader.ReadToEnd();
            }
        }
        catch (Exception exc)
        {
            // Show error.
            txtOutput.Text = string.Format(null, "Exception: {0}", exc.Message);
        }
    }
}