﻿<%@ Page Language="C#" AutoEventWireup="true" ValidateRequest="false" CodeBehind="Default.aspx.cs"
    Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>UltimateProxy - C# Web Sample</title>
    <link rel="Stylesheet" href="Css/Styles.css" />
</head>
<body>
    <form id="myform" runat="server">
        <div class="templatecontent">
            <div class="header">
                <a href="http://www.componentpro.com"><img src="Css/Logo.gif" /></a>
            </div>        
            This web application will illustrate how to use UltimateProxy in a Web Application.<br />
            <br />
            <b>How to use:</b> All fields in bold are required.<ul>
                <li><b>Proxy Server: </b>Enter the server address. </li>
                <li><strong>Proxy Port: </strong>Enter the server address. </li>
                <li><strong>Proxy Type: </strong>Enter the server address. </li>
                <li><strong>User Name: </strong>User name to submit to the proxy server for authentication.
                </li>
                <li><strong>Password: </strong>Password to submit to the proxy server for authentication.
                </li>
                <li><strong>Domain: </strong>Domain name to submit to the proxy server for authentication.
                </li>
                <li><strong>Authentication Method: </strong>The Authentication Method. </li>
                <li><strong>Host Name: </strong>The DNS name of the remote host to which you intend
                    to connect. </li>
                <li><strong>Port: </strong>The port number of the remote host to which you intend to
                    connect. </li>
                <li>Click on the <strong>Connect</strong> button to connect to the specified host through
                    the specified proxy server.</li>
            </ul>
            <div class="content">
                <table border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td style="white-space: nowrap">
                            Proxy Server:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtProxyServer" runat="server" CssClass="textbox"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Proxy Port:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtProxyPort" runat="server" CssClass="textbox" Width="50px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RangeValidator ID="rvProxyPort" runat="server" CssClass="error-1" Display="Dynamic"
                                ErrorMessage="Proxy Port number is invalid" ControlToValidate="txtProxyPort"
                                Type="Integer" MaximumValue="65535" MinimumValue="1"></asp:RangeValidator></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Proxy Type:</td>
                        <td width="100%">
                            <asp:DropDownList ID="ddlProxyType" runat="server" CssClass="dropdown">
                                <asp:ListItem>None</asp:ListItem>
                                <asp:ListItem>Socks4</asp:ListItem>
                                <asp:ListItem>Socks4a</asp:ListItem>
                                <asp:ListItem>Socks5</asp:ListItem>
                                <asp:ListItem>HttpConnect</asp:ListItem>
                            </asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap; height: 25px;">
                            User Name:</td>
                        <td width="100%" style="height: 25px">
                            <asp:TextBox ID="txtUserName" runat="server" CssClass="textbox"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Password:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtPassword" runat="server" CssClass="textbox" TextMode="Password"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Domain:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtDomain" runat="server" CssClass="textbox"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Authentication Method:</td>
                        <td width="100%">
                            <asp:DropDownList ID="ddlMethod" runat="server" CssClass="dropdown">
                                <asp:ListItem>Basic</asp:ListItem>
                                <asp:ListItem>Ntlm</asp:ListItem>
                            </asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Host Name:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtHostName" runat="server" CssClass="textbox">www.yahoo.com</asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfv" runat="server" CssClass="error-1" ErrorMessage="Host Name is required"
                                ControlToValidate="txtHostName" Display="Dynamic"></asp:RequiredFieldValidator></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Port:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtPort" runat="server" CssClass="textbox" Width="50px">80</asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvPort" runat="server" CssClass="error-1" ErrorMessage="Port is required"
                                ControlToValidate="txtPort" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RangeValidator ID="rvPort" runat="server" CssClass="error-1" Display="Dynamic"
                                ErrorMessage="Port number is invalid" ControlToValidate="txtPort" Type="Integer"
                                MaximumValue="65535" MinimumValue="1"></asp:RangeValidator></td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <asp:TextBox ID="txtOutput" runat="server" Columns="70" Rows="12" TextMode="MultiLine"
                                ReadOnly="True"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <asp:Button CssClass="okbutton" ID="btn" runat="server" Text="Send" OnClick="btn_Click" /></td>
                    </tr>
                </table>
            </div>
        </div>
    </form>
</body>
</html>
