﻿<%@ Page Language="vb" validateRequest="false" AutoEventWireup="true"  CodeBehind="Default.aspx.vb" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
	<title>UltimateDynamicTemplate and UltimateSmtp Integration Web Demonstration</title>
	<link rel="Stylesheet" href="Css/Styles.css" />
</head>
<body>
	<form id="myform" runat="server">
	<div class="templatecontent">
			<div class="header">
				<a href="http://www.componentpro.com">
					<img src="Css/Logo.gif" /></a>
			</div>
			This sample demonstrate how to use DynamicTemplate and Smtp components to generate and send an order invoice to a customer.<br />
&nbsp;&nbsp;- Press Preview button to preview the generated subject and body<br />
&nbsp;&nbsp;- Press Send button to send a mail with the generated subject and body<br />
&nbsp;&nbsp;<b>Remark</b>: <br />
&nbsp;&nbsp;&nbsp;&nbsp;User object has following Properties: EmailAddress, Password and FullName and one method named GetOrders.<br />
			<br />
<br /><b>How to use:</b> All fields in <strong>bold</strong> are required.<ul>
<li><b>Smtp Server: </b>The Smtp server address. </li>
	<li><strong>Smtp Port: </strong>The Smtp server port (default port is 25). </li>
	<li><strong>Security Mode: </strong>The SMTP connection security.
	</li>
	<li><strong>Smtp User: </strong>The Smtp User Name. </li>
	<li><strong>Password: </strong>The Password. </li>
	<li><strong>Authentication Method: </strong>.The SMTP client authentication method.</li>
	<li><strong>From Email: </strong>The author of this message. </li>
	<li><strong>To Email: </strong>The recipient of the message. </li>
	<li><strong>Subject: </strong>The subject of the message. </li>
	<li><strong>Content: </strong>The content of the message. </li>
<li>Click on the <strong>Send</strong> button to send the message.</li>
</ul>
	<div style="padding-bottom:5px">
		<table border="0" cellspacing="0" cellpadding="3">
			<tr>
				<td style="white-space:nowrap"><b>Smtp Server:</b></td>
				<td width="100%"><asp:TextBox ID="txtServer" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
			</tr>
			<tr>
				<td style="white-space:nowrap"></td>
				<td><asp:RequiredFieldValidator id="rfv" runat="server" CssClass="error-1" ErrorMessage="Smtp server Address is required"
													ControlToValidate="txtServer" Display="Dynamic"></asp:RequiredFieldValidator>
					</td>
			</tr>
			<tr>
				<td style="white-space:nowrap"><b>Smtp Port:</b></td>
				<td width="100%"><asp:TextBox ID="txtPort" runat="server" CssClass="textbox" Width="50px">25</asp:TextBox></td>
			</tr>
			<tr>
				<td style="white-space:nowrap"></td>
				<td><asp:RequiredFieldValidator id="rfvPort" runat="server" CssClass="error-1" ErrorMessage="Smtp port is required"
													ControlToValidate="txtPort" Display="Dynamic"></asp:RequiredFieldValidator>
													<asp:RangeValidator ID="rvPort" runat="server" CssClass="error-1" ControlToValidate="txtPort"
						ErrorMessage="Smtp Port is invalid" MaximumValue="65535" MinimumValue="1" Type="Integer"></asp:RangeValidator>
													</td>
			</tr>
			<tr>
				<td style="white-space:nowrap">Security Mode:</td>
				<td width="100%"><asp:DropDownList ID="ddlSecurityMode" runat="server" CssClass="dropdown" Width="200px">
					<asp:ListItem>Unsecure</asp:ListItem>
					<asp:ListItem>Implicit</asp:ListItem>
					<asp:ListItem>Explicit</asp:ListItem>                    
				</asp:DropDownList></td>
			</tr>
			<tr>
				<td style="white-space:nowrap">Smtp User:</td>
				<td width="100%"><asp:TextBox ID="txtUser" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
			</tr>
			<tr>
				<td style="white-space:nowrap">Password:</td>
				<td width="100%"><asp:TextBox ID="txtPassword" runat="server" CssClass="textbox" Width="200px" TextMode="Password"></asp:TextBox></td>
			</tr>            
			<tr>
				<td style="white-space:nowrap">Authentication Method:</td>
				<td width="100%"><asp:DropDownList ID="ddlAuthentication" runat="server" CssClass="dropdown" Width="200px">
					<asp:ListItem>Auto</asp:ListItem>
					<asp:ListItem>CramMD5</asp:ListItem>
					<asp:ListItem>DigestMD5</asp:ListItem>
					<asp:ListItem>Login</asp:ListItem>
					<asp:ListItem>Ntlm</asp:ListItem>
					<asp:ListItem>Plain</asp:ListItem>
				</asp:DropDownList></td>
			</tr>            
			<tr>
				<td style="white-space:nowrap"><b>From Email:</b></td>
				<td width="100%"><asp:TextBox ID="txtFrom" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
			</tr>
			<tr>
				<td style="white-space:nowrap"></td>
				<td><asp:RequiredFieldValidator id="rfvFrom" runat="server" CssClass="error-1" ErrorMessage="From email is required"
													ControlToValidate="txtFrom" Display="Dynamic"></asp:RequiredFieldValidator>
					<asp:RegularExpressionValidator ID="revFrom" runat="server" ControlToValidate="txtFrom" CssClass="error-1"
						Display="Dynamic" ErrorMessage="From Email is invalid" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:RegularExpressionValidator></td>
			</tr>
			<tr>
				<td style="white-space:nowrap"><b>To Email:</b></td>
				<td width="100%"><asp:TextBox ID="txtTo" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
			</tr>
			<tr>
				<td style="white-space:nowrap"></td>
				<td><asp:RequiredFieldValidator id="rfvTo" runat="server" CssClass="error-1" ErrorMessage="To email is required"
													ControlToValidate="txtTo" Display="Dynamic"></asp:RequiredFieldValidator>
					<asp:RegularExpressionValidator ID="revTo" runat="server" ControlToValidate="txtTo"
						CssClass="error-1" Display="Dynamic" ErrorMessage="To Email is invalid" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:RegularExpressionValidator></td>
			</tr>            
			<tr>
				<td style="white-space:nowrap">Subject:</td>
				<td width="100%"><asp:TextBox ID="txtSubject" runat="server" CssClass="textbox" Width="450px">Invoice for Order #$OrderId$</asp:TextBox></td>
			</tr>
			<tr>
				<td style="white-space:nowrap">Content:</td>
				<td width="100%"><asp:TextBox ID="txtContent" runat="server" CssClass="textbox" Width="450px" Height="200px" TextMode="MultiLine">
Dear $User.FullName$,
{%set orders=User.GetOrders() /}
Thank you for your order of $orders.Length$ items, We believe you will be very satisfied with the quality of costume pieces included in each. It is this quality that makes our imaginative play apparel so unique.

We created an account for you to track your orders. Here is the login information:
Email: $User.EmailAddress$
Password: $User.Password$

Following is the details of your order (OrderId: $OrderId$):
#   Part ID    Name            Quantity     Price(per unit)       Sub Total
{%set Total=0.0 /}{%foreach orderproduct,i in orders%}{%set Total = Total + orderproduct.Price * orderproduct.Quantity/}
{%rendertemplate orderproducttemplate item=orderproduct/}{$foreach%}
																							   Total: $PadLeft(Format(Total,"$$#.##"),12)$

If you have any concern, please call us at 913-555-0115.

Sincerely,

$CompanyName$

{%template orderproducttemplate%}$PadLeft(i,4)$$PadLeft(item.PartId, 7)$    $PadRight(item.ProductName, 15)$        $PadRight(item.Quantity, 5)$        $PadLeft(Format(item.Price,"$$#.##"), 7)$   $PadLeft(Format(item.Price*item.Quantity,"$$#.##"), 12)${$template%}
</asp:TextBox></td>
			</tr>
			<tr>
				<td colspan="2"><asp:Label ID="lblResult" runat="server" CssClass="bodytext"></asp:Label></td>
			</tr>
			<tr><td colspan="2"><asp:Button CssClass="okbutton" ID="btnSend" runat="server" Text="Send" OnClick="btnSend_Click"/></td></tr>
		</table>
	</div>
	</div>
	</form>
</body>
</html>