Imports ComponentPro.Net
Imports ComponentPro.Net.Mail

Namespace SmtpSendMail
	Partial Public Class Settings
		Inherits Form
		Private _security As SecurityMode
		Private _sign As Boolean
		Private _encrypt As Boolean
		Private _cert As String
		Private _suites As Integer

		Private _server As String
		Private _port As Integer
		Private _timeout As Integer
		Private _userName As String
		Private _password As String
		Private _method As SmtpAuthenticationMethod

		Private _proxyServer As String
		Private _proxyUserName As String
		Private _proxyPassword As String
		Private _proxyDomain As String
		Private _proxyPort As Integer
		Private _proxyAuthenticationMethod As ProxyHttpConnectAuthMethod
		Private _proxyType As ProxyType

		Public Sub New()
			InitializeComponent()

			Util.PopulateEnum(GetType(SecurityMode), cbxSec)
			Util.PopulateEnum(GetType(SmtpAuthenticationMethod), cbxMethod)
		End Sub

		''' <summary>
		''' Handles the OK button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnOK_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnOK.Click
			_sign = chkSign.Checked
			_encrypt = chkEncrypt.Checked
			_security = CType(cbxSec.SelectedIndex, SecurityMode)

			If txtServer.Text.Trim().Length = 0 Then
				MessageBox.Show("Please enter SMTP server", "Error")
				Return
			End If

			_server = txtServer.Text

			Try
				_timeout = Integer.Parse(txtTimeout.Text)
			Catch e1 As FormatException
				_timeout = 60000
				MessageBox.Show("Invalid timeout", "Error")
				Return
			End Try

			Try
				Dim serverport As Integer = Integer.Parse(txtPort.Text)
				If serverport < 1 OrElse serverport > 65535 Then
					MessageBox.Show("Invalid port, port must be from 1->65535", "Error")
					Return
				End If
				_port = serverport
			Catch e2 As FormatException
				MessageBox.Show("Invalid port, port must be from 1->65535", "Error")
				Return
			End Try

			If txtProxyPort.Text.Length > 0 Then
				Try
					Dim pport As Integer
					pport = Integer.Parse(txtProxyPort.Text)
					If pport < 1 OrElse pport > 65535 Then
						MessageBox.Show("Invalid port number, must be between 1 and 65535")
						Return
					End If
					_proxyPort = pport
				Catch exc As Exception
					MessageBox.Show("Invalid port: " & exc.Message)
					Return
				End Try
			End If

			If txtProxyPassword.Text.Length > 0 AndAlso txtProxyUserName.Text.Length = 0 Then
				MessageBox.Show("Please enter user name")
				Return
			End If

			_userName = txtUserName.Text
			_password = txtPassword.Text

			_method = CType(cbxMethod.SelectedItem, SmtpAuthenticationMethod)
			_cert = txtCertificate.Text

			_proxyServer = txtProxyHost.Text
			_proxyType = CType(cbxType.SelectedIndex, ProxyType)
			_proxyAuthenticationMethod = CType(cbxProxyMethod.SelectedIndex, ProxyHttpConnectAuthMethod)
			_proxyUserName = txtProxyUserName.Text
			_proxyPassword = txtProxyPassword.Text
			_proxyDomain = txtProxyDomain.Text

			Me.DialogResult = System.Windows.Forms.DialogResult.OK
		End Sub

		Public Property Security() As SecurityMode
			Get
				Return _security
			End Get
			Set(ByVal value As SecurityMode)
				_security = value
			End Set
		End Property

		Public Property Sign() As Boolean
			Get
				Return _sign
			End Get
			Set(ByVal value As Boolean)
				_sign = value
			End Set
		End Property

		Public Property Encrypt() As Boolean
			Get
				Return _encrypt
			End Get
			Set(ByVal value As Boolean)
				_encrypt = value
			End Set
		End Property

		Public Property Cert() As String
			Get
				Return _cert
			End Get
			Set(ByVal value As String)
				_cert = value
			End Set
		End Property

		Public Property Server() As String
			Get
				Return _server
			End Get
			Set(ByVal value As String)
				_server = value
			End Set
		End Property

		Public Property Port() As Integer
			Get
				Return _port
			End Get
			Set(ByVal value As Integer)
				_port = value
			End Set
		End Property

		Public Property Timeout() As Integer
			Get
				Return _timeout
			End Get
			Set(ByVal value As Integer)
				_timeout = value
			End Set
		End Property

		Public Property UserName() As String
			Get
				Return _userName
			End Get
			Set(ByVal value As String)
				_userName = value
			End Set
		End Property

		Public Property Password() As String
			Get
				Return _password
			End Get
			Set(ByVal value As String)
				_password = value
			End Set
		End Property

		Public Property Method() As SmtpAuthenticationMethod
			Get
				Return _method
			End Get
			Set(ByVal value As SmtpAuthenticationMethod)
				_method = value
			End Set
		End Property

		Public Property Suites() As Integer
			Get
				Return _suites
			End Get
			Set(ByVal value As Integer)
				_suites = value
			End Set
		End Property

		#Region "Proxy"



		Public Property ProxyServer() As String
			Get
				Return _proxyServer
			End Get
			Set(ByVal value As String)
				_proxyServer = value
			End Set
		End Property

		Public Property ProxyUserName() As String
			Get
				Return _proxyUserName
			End Get
			Set(ByVal value As String)
				_proxyUserName = value
			End Set
		End Property

		Public Property ProxyPassword() As String
			Get
				Return _proxyPassword
			End Get
			Set(ByVal value As String)
				_proxyPassword = value
			End Set
		End Property

		Public Property ProxyDomain() As String
			Get
				Return _proxyDomain
			End Get
			Set(ByVal value As String)
				_proxyDomain = value
			End Set
		End Property

		Public Property ProxyPort() As Integer
			Get
				Return _proxyPort
			End Get
			Set(ByVal value As Integer)
				_proxyPort = value
			End Set
		End Property

		Public Property ProxyAuthenticationMethod() As ProxyHttpConnectAuthMethod
			Get
				Return _proxyAuthenticationMethod
			End Get
			Set(ByVal value As ProxyHttpConnectAuthMethod)
				_proxyAuthenticationMethod = value
			End Set
		End Property

		Public Property ProxyType() As ProxyType
			Get
				Return _proxyType
			End Get
			Set(ByVal value As ProxyType)
				_proxyType = value
			End Set
		End Property

		#End Region

		''' <summary>
		''' Handles the form's Load event.
		''' </summary>
		''' <param name="sender">The form object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub SecuritySettings_Load(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Load
			txtCertificate.Text = _cert

			chkEncrypt.Checked = _encrypt
			chkSign.Checked = _sign

			Select Case _security
				Case SecurityMode.Implicit
					cbxSec.SelectedIndex = 2

				Case SecurityMode.Explicit
					cbxSec.SelectedIndex = 1

				Case SecurityMode.None
					cbxSec.SelectedIndex = 0
			End Select

			If _timeout >= 1000 Then
				txtTimeout.Text = _timeout.ToString()
			End If
			txtServer.Text = _server
			If _port > 0 Then
				txtPort.Text = _port.ToString()
			End If
			txtUserName.Text = _userName
			txtPassword.Text = _password

			Select Case _method
				Case SmtpAuthenticationMethod.Auto
					cbxMethod.SelectedIndex = 0
				Case SmtpAuthenticationMethod.SaslCramMd5
					cbxMethod.SelectedIndex = 1
				Case SmtpAuthenticationMethod.SaslDigestMd5
					cbxMethod.SelectedIndex = 2
				Case SmtpAuthenticationMethod.SaslLogin
					cbxMethod.SelectedIndex = 3
				Case SmtpAuthenticationMethod.SaslNtlm
					cbxMethod.SelectedIndex = 4
				Case SmtpAuthenticationMethod.SaslPlain
					cbxMethod.SelectedIndex = 5
			End Select

			txtProxyUserName.Text = _proxyUserName
			txtProxyPassword.Text = _proxyPassword
			txtProxyDomain.Text = _proxyDomain
			txtProxyHost.Text = _proxyServer
			If _proxyPort > 0 Then
				txtProxyPort.Text = _proxyPort.ToString()
			End If
			cbxProxyMethod.SelectedIndex = CInt(Fix(_proxyAuthenticationMethod))
			cbxType.SelectedIndex = CInt(Fix(_proxyType))
		End Sub

		''' <summary>
		''' Handles the Certificate browe button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnCertBrowse_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnCertBrowse.Click
			Dim dlg As New OpenFileDialog()
			dlg.Title = "Select a certificate file"
			dlg.FileName = txtCertificate.Text
			dlg.Filter = "All files|*.*"
			dlg.FilterIndex = 1
			If dlg.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
				txtCertificate.Text = dlg.FileName
			End If
		End Sub

		''' <summary>
		''' Handles the combo box proxy type's SelectedIndexChanged event.
		''' </summary>
		''' <param name="sender">The combo box.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub cbx_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles cbxProxyMethod.SelectedIndexChanged, cbxType.SelectedIndexChanged
			Dim enable As Boolean = cbxType.SelectedIndex > 0

			cbxProxyMethod.Enabled = cbxType.SelectedIndex = CInt(Fix(ProxyType.HttpConnect)) ' Authentication method is available for HTTP Connect only.
			txtProxyDomain.Enabled = cbxProxyMethod.Enabled AndAlso cbxProxyMethod.SelectedIndex = CInt(Fix(ProxyHttpConnectAuthMethod.Ntlm)) ' Domain is available for NTLM authentication method only.
			txtProxyUserName.Enabled = enable ' User name and password are ignored with SendToProxy proxy type. -  && cbxType.SelectedIndex != (int)ProxyType.SendToProxy
			txtProxyPassword.Enabled = enable ' && cbxType.SelectedIndex != (int)ProxyType.SendToProxy
			txtProxyHost.Enabled = enable ' Proxy host and port are not available in NoProxy type.
			txtProxyPort.Enabled = enable
		End Sub
	End Class
End Namespace