Imports ComponentPro.Net
Imports ComponentPro.Security.Certificates

Namespace Pop3Client.Security
	Friend Class CustomCertProvider
		Implements ICertificateChainProvider
		''' <summary>
		''' Validates a certificate and returns a chain object.
		''' </summary>
		''' <param name="info">The request info.</param>
		''' <returns>CertificateChain chain object.</returns>
		Public Function GetChain(ByVal info As CertificateChainProviderRequestInfo) As X509CertificateChain
			Dim my As New CertificateStore("MY")
			Dim certs() As X509Certificate

			If info.GetIssuers().Length > 0 Then
				certs = my.GetCertificates(info.GetIssuers(), CertificateSearchType.TimeValid Or CertificateSearchType.HasPrivateKey Or CertificateSearchType.ClientAuthentication)
			Else
				certs = my.GetCertificates(CertificateSearchType.TimeValid Or CertificateSearchType.HasPrivateKey Or CertificateSearchType.ClientAuthentication)
			End If

			If certs.Length = 0 Then
				Return Nothing
			End If

			Dim rhForm As New CertProvider()
			rhForm.LoadData(certs)

			If rhForm.ShowDialog() = System.Windows.Forms.DialogResult.OK Then
				If rhForm.SelectedCertificate IsNot Nothing Then
					Return X509CertificateChain.Create(rhForm.SelectedCertificate)
				End If
			End If

			Return Nothing
		End Function
	End Class
End Namespace