Imports System.ComponentModel
Imports System.Text
Imports ComponentPro.Net
Imports ComponentPro.Net.Mail
Imports ComponentPro.Security.Certificates
Imports ImapClient.Security

Namespace ImapClient
	Partial Public Class ImapClient
		#Region "Toolbar"

		Private Sub tsbRefresh_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbRefresh.Click
			RefreshFolderList()
		End Sub

		Private Sub tsbDelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbDelete.Click
			' Delete folder or message?
			If treeView.Focused Then
				DeleteFolder()
			Else
				DeleteMessages()
			End If
		End Sub

		Private Sub tsbUndelete_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbUndelete.Click
			UndeleteMessages()
		End Sub

		Private Sub tsbOpen_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbOpen.Click
			RemoveHandler client.Progress, AddressOf client_Progress
			Dim form As New MessageViewer(client, CType(listView.SelectedItems(0).Tag, ListItemTagInfo).UniqueId)
			' Show the MessageViewer form.
			Dim r As DialogResult = form.ShowDialog()
			AddHandler client.Progress, AddressOf client_Progress
			If r = DialogResult.Abort Then
				' Reconnect to the Imap server if the opening operation has been aborted.
				Reconnect(Nothing)
			End If
		End Sub

		Private Sub tsbSaveAs_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbSaveAs.Click
			Dim sav As New SaveFileDialog()
			sav.Filter = "Email files (*.eml)|*.eml|All files (*.*)|*.*"
			sav.FilterIndex = 1
			sav.Title = "Save the mail as"

			' Show the Save File as dialog.
			If sav.ShowDialog() = DialogResult.OK Then
				Try
					EnableProgress(True, 100)
					Application.DoEvents()

					' Get unique Id string.
					Dim uniqueId As String = CType(listView.SelectedItems(0).Tag, ListItemTagInfo).UniqueId
					AddHandler client.Progress, AddressOf client_Progress
					client.DownloadMessage(uniqueId, sav.FileName)
				Catch exc As Exception
					If _cancelling Then
						Reconnect(Nothing)
					Else
						Reconnect(exc)
					End If
				Finally
					RemoveHandler client.Progress, AddressOf client_Progress
					EnableProgress(False, 0)
				End Try
			End If
		End Sub

		Private Sub tsbLogin_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbLogin.Click
			' Show the Login form.
			Dim form As New Login(_settings)
			If form.ShowDialog() = DialogResult.OK Then
				Connect()
			End If
		End Sub

		Private Sub tsbLogout_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbLogout.Click
			Disconnect()
		End Sub

		#End Region
	End Class
End Namespace