﻿Imports ComponentPro.Net

Namespace ImapClient
	Partial Public Class ImapClient
		Inherits Form
		''' <summary>
		''' Defines connection states.
		''' </summary>
		Private Enum ConnectionState
			NotConnected
			Connecting
			Ready
			Disconnecting
		End Enum

		Private ReadOnly _exception As Boolean ' Incidates whether a licensing exception has occurred.
		Private _messagesDelete As Boolean

		Private _settings As LoginInfo ' Login information.
		Private _state As ConnectionState ' Current connection state.

		Private _disableCount As Integer

		Private _currentFolder As String = String.Empty ' Selected folder name.

		Public Sub New()
			Try
				InitializeComponent()
			Catch exc As Exception
				If TypeOf exc Is ComponentPro.Licensing.Mail.UltimateLicenseException Then
					MessageBox.Show(exc.Message, "Error")
					_exception = True
					Return
				End If

				Throw
			End Try

			'#if DEBUG
			'ComponentPro.Diagnostics.XTrace.Level = System.Diagnostics.TraceEventType.Transfer;
			'ComponentPro.Diagnostics.XTrace.AutoFlush = true;
			'// Add the UltimateTextWriterTraceListener listener to write to a file.
			'ComponentPro.Diagnostics.XTrace.Listeners.Add(new ComponentPro.Diagnostics.UltimateTextWriterTraceListener("log.log"));
			'#endif

		End Sub

		''' <summary>
		''' Handles the form's Load event.
		''' </summary>
		''' <param name="e">The event arguments.</param>
		Protected Overrides Sub OnLoad(ByVal e As EventArgs)
			MyBase.OnLoad(e)
			' Close the application if an exception occurred.
			If _exception Then
				Me.Close()
			End If

			' Load settings from the Registry.
			_settings = LoginInfo.LoadConfig()
		End Sub

		''' <summary>
		''' Handles the form's Closed event.
		''' </summary>
		''' <param name="e">The event arguments.</param>
		Protected Overrides Sub OnClosed(ByVal e As EventArgs)
			' Make sure to close the IMAP session before leaving.
			If tsbLogout.Visible Then
				' Close the connection.
				Disconnect()

				' Wait for the completion.
				Do While _state <> ConnectionState.NotConnected
					System.Threading.Thread.Sleep(50)
					' Wake up the GUI.
					System.Windows.Forms.Application.DoEvents()
				Loop
			End If

			' And save the settings.
			_settings.SaveConfig()

			MyBase.OnClosed(e)
		End Sub

		''' <summary>
		''' Closes the connection and release used resources.
		''' </summary>
		Private Async Sub Disconnect()
			' Disable the session timeout timer.
			sessionTimeoutTimer.Enabled = False

			If _messagesDelete Then
				_messagesDelete = False
				SetStatusText("Applying changes...")
				client.Purge()
			End If

			' Set Disconnecting state.
			_state = ConnectionState.Disconnecting
			SetStatusText("Disconnecting...")

			Try
				' Asynchronously disconnect.
				Await client.DisconnectAsync()
			Catch exc As Exception
				Util.ShowError(exc)
				SetStatusText("Ready")
			End Try

			' Set disconnected state.
			SetDisconnectedState()
		End Sub

		''' <summary>
		''' Logins to the IMAP server.
		''' </summary>
		Private Async Sub Connect()
			' Set timeout.
			client.Timeout = _settings.Timeout

			Dim proxy As New WebProxyEx()
			client.Proxy = proxy
			' Setup proxy.
			If _settings.ProxyServer.Length > 0 AndAlso _settings.ProxyPort > 0 Then
				proxy.Server = _settings.ProxyServer
				proxy.Port = _settings.ProxyPort
				proxy.UserName = _settings.ProxyUserName
				proxy.Password = _settings.ProxyPassword
				proxy.ProxyType = _settings.ProxyType
				proxy.Domain = _settings.ProxyDomain
				proxy.AuthenticationMethod = _settings.ProxyAuthenticationMethod
			End If

			SetStatusText("Connecting to {0}:{1}...", _settings.Server, _settings.Port)
			_state = ConnectionState.Connecting
			' Disable controls.
			EnableDialog(False)

			tsbCancel.Visible = True

			Try
				' Connect to the IMAP server.
				Await client.ConnectAsync(_settings.Server, _settings.Port, _settings.SecurityMode)
			Catch exc As Exception
				Util.ShowError(exc)
				Disconnect()
				Return
			End Try

			Authenticate()
		End Sub

		Private Sub EnableDialogImm(ByVal enable As Boolean)
			listView.Enabled = enable
			treeView.Enabled = enable
			EnableContextMenus(enable)
			tsbCancel.Visible = False

			For Each item As ToolStripItem In toolbarMain.Items
				If item IsNot tsbCancel Then
					If enable Then
						item.Enabled = CBool(item.Tag)
					Else
						item.Tag = item.Enabled
						item.Enabled = enable
					End If
				End If
			Next item

			Util.EnableCloseButton(Me, enable)
		End Sub

		Private Sub EnableProgress(ByVal enable As Boolean, ByVal maxValue As Integer)
			_cancelling = False
			toolStripStatusLabel.Visible = Not enable
			toolStripProgressBar.Visible = enable
			toolStripProgressBar.Value = 0
			toolStripProgressBar.Maximum = maxValue
			toolStripProgressCancelButton.Visible = enable
			toolStripProgressLabel.Text = String.Empty
			toolStripProgressLabel.Visible = enable

			EnableDialog((Not enable))
		End Sub

		Private Sub EnableDialog(ByVal enable As Boolean)
			If enable Then
				If _disableCount > 0 Then
					_disableCount -= 1
					If _disableCount = 0 Then
						EnableDialogImm(True)
						SetStatusText("Ready")
					End If
				End If
			Else
				If _disableCount = 0 Then
					EnableDialogImm(False)
				End If
				_disableCount += 1
			End If
		End Sub

		''' <summary>
		''' Sets the status text.
		''' </summary>
		''' <param name="str">The new status text.</param>
		Private Sub SetStatusText(ByVal str As String)
			toolStripStatusLabel.Text = str
		End Sub

		''' <summary>
		''' Sets the status text.
		''' </summary>
		''' <param name="str">The new status format text.</param>
		''' <param name="parameters">The parameters.</param>
		Private Sub SetStatusText(ByVal str As String, ParamArray ByVal parameters() As Object)
			toolStripStatusLabel.Text = String.Format(str, parameters)
		End Sub

		Private Sub tsbPurge_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbPurge.Click
			PurgeMessages()
		End Sub

		Private Sub toolStripProgressCancelButton_ButtonClick(ByVal sender As Object, ByVal e As EventArgs) Handles toolStripProgressCancelButton.ButtonClick
			' Cancel operation.
			_cancelling = True
			client.Cancel()
		End Sub

		Private Sub openContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles openContextMenuItem.Click
			tsbOpen_Click(sender, Nothing)
		End Sub

		Private Sub deleteContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles deleteContextMenuItem.Click
			tsbDelete_Click(sender, Nothing)
		End Sub

		Private Sub undeleteContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles undeleteContextMenuItem.Click
			tsbUndelete_Click(sender, Nothing)
		End Sub

		Private Sub saveMessageAsContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles saveMessageAsContextMenuItem.Click
			tsbSaveAs_Click(sender, Nothing)
		End Sub

		Private Sub newFolderContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles newFolderContextMenuItem.Click
			NewFolder()
		End Sub

		Private Sub deleteFolderContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles deleteFolderContextMenuItem.Click
			DeleteFolder()
		End Sub

		Private Sub renameContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles renameContextMenuItem.Click
			treeView.SelectedNode.BeginEdit()
		End Sub

		Private Sub pasteMessagesContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles pasteMessagesTreeViewContextMenuItem.Click
			PasteMessage(_currentFolder)
		End Sub

		Private Sub purgeDeletedMessagesContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles purgeDeletedMessagesContextMenuItem.Click
			PurgeMessages()
		End Sub

		Private Sub sessionTimeoutTimer_Tick(ByVal sender As Object, ByVal e As EventArgs) Handles sessionTimeoutTimer.Tick
			Try
				' Check connection state.
				If (Not client.IsBusy) AndAlso _state = ConnectionState.Ready AndAlso (Not client.IsConnected) Then
					SetDisconnectedState()
				End If
			Catch
				' Close the connection if it's is closed by the server.
				Disconnect()
			End Try
		End Sub

		Private Sub copyToolStripMenuItem1_Click(ByVal sender As Object, ByVal e As EventArgs) Handles copyToolStripMenuItem.Click
			tsbCopy_Click(sender, Nothing)
		End Sub

		Private Sub pasteToolStripMenuItem1_Click(ByVal sender As Object, ByVal e As EventArgs) Handles pasteToolStripMenuItem.Click
			tsbPaste_Click(sender, Nothing)
		End Sub

		Private Sub copyToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles copyContextMenuItem.Click
			tsbCopy_Click(sender, Nothing)
		End Sub

		Private Sub pasteToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles pasteContextMenuItem.Click
			tsbPaste_Click(sender, Nothing)
		End Sub

		Private Sub tsbCopy_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbCopy.Click
			CopyMessage()
		End Sub

		Private Sub tsbPaste_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbPaste.Click
			PasteMessage(_currentFolder)
		End Sub

		Private Sub uploadLocalMessagesContextMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles uploadLocalMessagesContextMenuItem.Click
			UploadMessage()
		End Sub

		Private Sub uploadMessageToolStripMenuItem_Click(ByVal sender As Object, ByVal e As EventArgs) Handles uploadMessageToolStripMenuItem.Click
			UploadMessage()
		End Sub

		Private Sub tsbUpload_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbUpload.Click
			UploadMessage()
		End Sub

		Private Sub tsbCancel_Click(ByVal sender As Object, ByVal e As EventArgs) Handles tsbCancel.Click
			client.Cancel()
			tsbCancel.Visible = False
		End Sub
	End Class
End Namespace
