Imports System.ComponentModel
Imports System.Text
Imports ComponentPro.Net
Imports ComponentPro.Net.Mail
Imports ComponentPro.Security.Certificates
Imports ImapClient.Security

Namespace ImapClient
	Partial Public Class ImapClient
		Private _lastColumnToSort As Integer
		Private _lastSortOrder As SortOrder

		''' <summary>
		''' Handles the message list view's SelectedIndexChanged event.
		''' </summary>
		''' <param name="sender">The message list view object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub listView_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles listView.SelectedIndexChanged
			Dim enable As Boolean = listView.Focused AndAlso listView.SelectedItems.Count > 0
			Dim undoable As Boolean = enable AndAlso (listView.SelectedItems.Count > 1 OrElse listView.SelectedItems(0).SubItems(3).Text = "Delete")

			' Enable/disable toolbar buttons accordingly.
			tsbDelete.Enabled = enable AndAlso (listView.SelectedItems.Count > 1 OrElse listView.SelectedItems(0).SubItems(3).Text <> "Delete")
			tsbUndelete.Enabled = undoable
			tsbOpen.Enabled = enable
			tsbSaveAs.Enabled = enable
			tsbCopy.Enabled = enable
			tsbPaste.Enabled = _copyInfo IsNot Nothing AndAlso _copyInfo.Count > 0 AndAlso Not String.IsNullOrEmpty(_currentFolder)
			tsbUpload.Enabled = _currentFolder.Length > 0

			' Enable/disable menu items accordingly.
			deleteContextMenuItem.Enabled = tsbDelete.Enabled
			undeleteContextMenuItem.Enabled = undoable
			openContextMenuItem.Enabled = enable
			saveMessageAsContextMenuItem.Enabled = enable
			copyToolStripMenuItem.Enabled = enable
			copyContextMenuItem.Enabled = enable
			pasteMessagesTreeViewContextMenuItem.Enabled = tsbPaste.Enabled
			pasteToolStripMenuItem.Enabled = tsbPaste.Enabled
			pasteContextMenuItem.Enabled = tsbPaste.Enabled

			purgeDeletedMessagesContextMenuItem.Enabled = _currentFolder.Length > 0
			tsbPurge.Enabled = _currentFolder.Length > 0
			uploadLocalMessagesContextMenuItem.Enabled = _currentFolder.Length > 0
			uploadMessageToolStripMenuItem.Enabled = _currentFolder.Length > 0
		End Sub

		''' <summary>
		''' Handles the message list view's DoubleClick event.
		''' </summary>
		''' <param name="sender">The list view control.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub listView_DoubleClick(ByVal sender As Object, ByVal e As EventArgs) Handles listView.DoubleClick
			tsbOpen_Click(sender, Nothing)
		End Sub

		''' <summary>
		''' Handles the message list view's ColumnClick event.
		''' </summary>
		''' <param name="sender">The list view control.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub listView_ColumnClick(ByVal sender As Object, ByVal e As ColumnClickEventArgs) Handles listView.ColumnClick
			' Return if no messages found.
			If listView.Items.Count = 0 Then
				Return
			End If

			Dim sortOrder As SortOrder
			If _lastColumnToSort = e.Column Then
				If _lastSortOrder = SortOrder.Ascending Then
					sortOrder = SortOrder.Descending
				Else
					sortOrder = SortOrder.Ascending
				End If
			Else
				sortOrder = SortOrder.Ascending
			End If

			Select Case e.Column
				Case 0, 1, 3
					listView.ListViewItemSorter = New ListViewItemNameSorter(e.Column, sortOrder) ' Sort by subitem's text.

				Case 2
					listView.ListViewItemSorter = New ListViewItemDateSorter(e.Column, sortOrder) ' Sort by date time.

				Case 4
					listView.ListViewItemSorter = New ListViewItemSizeSorter(e.Column, sortOrder) ' Sort by size.
			End Select

			_lastColumnToSort = e.Column
			_lastSortOrder = sortOrder
		End Sub
	End Class
End Namespace