Imports System.Web.UI.WebControls
Imports ComponentPro.Net.Mail
Imports ComponentPro.Net

Partial Public Class _Default
	Inherits System.Web.UI.Page
	Private Sub PopulateEnum()
		Dim arr() As SmtpAuthenticationMethod = CType(System.Enum.GetValues(GetType(SmtpAuthenticationMethod)), SmtpAuthenticationMethod())

		For i As Integer = 0 To arr.Length - 1
			ddlAuthentication.Items.Add(New ListItem(arr(i).ToString(), CInt(arr(i)).ToString()))
		Next i

		Dim index As Integer
		If Integer.TryParse(Request.Form("ddlAuthentication"), index) Then
			ddlAuthentication.SelectedIndex = index
		End If
	End Sub

	Public Sub New()
		ComponentPro.Security.SecuritySettings.MediumTrust = True
	End Sub

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		PopulateEnum()
	End Sub

	''' <summary>
	''' Handles the Send button's Click event.
	''' </summary>
	''' <param name="sender">The button object.</param>
	''' <param name="e">The event arguments.</param>
	Protected Sub btnSend_Click(ByVal sender As Object, ByVal e As EventArgs)
		' Create a new Smtp client object.
		Dim client As New Smtp()

		Try
			' Parse the port number.
			Dim port As Integer = Integer.Parse(txtPort.Text)

			' Create a new mail message object.
			Dim msg As New MailMessage()
			' Set From and to.
			msg.From.Add(txtFrom.Text)
			msg.To.Add(txtTo.Text)
			' Subject and content of the message.
			msg.Subject = txtSubject.Text
			msg.BodyText = txtContent.Text

			' Connect to the server.
			client.Connect(txtServer.Text, port, CType(ddlSecurityMode.SelectedIndex, SecurityMode))

			If txtUser.Text.Trim().Length > 0 Then
				Dim ia As SmtpAuthenticationMethod = CType(Integer.Parse(ddlAuthentication.SelectedValue), SmtpAuthenticationMethod)

				' Login to the server.
				client.Authenticate(txtUser.Text, txtPassword.Text, ia)
			End If

			' Send the message.
			client.Send(msg)

			' Show the message has been sent.
			lblResult.Text = "Message has been sent!"
		Catch exc As Exception
			' Show exception message.
			lblResult.Text = String.Format(Nothing, "Exception: {0}", exc.Message)
		Finally
			' Disconnect.
			client.Disconnect()
		End Try
	End Sub
End Class