using System;
using System.Web.UI.WebControls;
using ComponentPro.Net.Mail;
using ComponentPro.Net;

public partial class _Default : System.Web.UI.Page 
{
    void PopulateEnum()
    {
        SmtpAuthenticationMethod[] arr = (SmtpAuthenticationMethod[])Enum.GetValues(typeof(SmtpAuthenticationMethod));

        for (int i = 0; i < arr.Length; i++)
        {
            ddlAuthentication.Items.Add(new ListItem(arr[i].ToString(), ((int)arr[i]).ToString()));
        }

        int index;
        if (int.TryParse(Request.Form["ddlAuthentication"], out index))
            ddlAuthentication.SelectedIndex = index;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        PopulateEnum();
    }
    
    /// <summary>
    /// Handles the Send button's Click event.
    /// </summary>
    /// <param name="sender">The button object.</param>
    /// <param name="e">The event arguments.</param>
    protected void btnSend_Click(object sender, EventArgs e)
    {
        // Create a new Smtp client object.
        Smtp client = new Smtp();

        try
        {
            // Parse the port number.
            int port = int.Parse(txtPort.Text);

            // Create a new mail message object.
            MailMessage msg = new MailMessage();
            // Set From and to.
            msg.From.Add(txtFrom.Text);
            msg.To.Add(txtTo.Text);
            // Subject and content of the message.
            msg.Subject = txtSubject.Text;
            msg.BodyText = txtContent.Text;

            // Connect to the server.
            client.Connect(txtServer.Text, port, (SecurityMode)ddlSecurityMode.SelectedIndex);

            if (txtUser.Text.Trim().Length > 0)
            {
                SmtpAuthenticationMethod ia = (SmtpAuthenticationMethod)int.Parse(ddlAuthentication.SelectedValue);

                // Login to the server.
                client.Authenticate(txtUser.Text, txtPassword.Text, ia);
            }

            // Send the message.
            client.Send(msg);

            // Show the message has been sent.
            lblResult.Text = "Message has been sent!";
        }
        catch (Exception exc)
        {
            // Show exception message.
            lblResult.Text = string.Format(null, "Exception: {0}", exc.Message);
        }
        finally
        {
            // Disconnect.
            client.Disconnect();
        }
    }
}