﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>UltimateMail Web Demonstration</title>
    <link rel="Stylesheet" href="Css/Styles.css" />
</head>
<body>
    <form id="myform" runat="server">
        <div class="templatecontent">
            <div class="header">
                <a href="http://www.componentpro.com">
                    <img src="Css/Logo.gif" /></a>
            </div>
            This example shows how to use UltimateMail to send mail in a Web Application.<br />
            <br />
            <b>How to use:</b> All fields in <strong>bold</strong> are required.<ul>
                <li><b>Smtp Server: </b>The Smtp server address. </li>
                <li><strong>Smtp Port: </strong>The Smtp server port (default port is 25). </li>
                <li><strong>Security Mode: </strong>The SMTP connection security. </li>
                <li><strong>Smtp User: </strong>The Smtp User Name. </li>
                <li><strong>Password: </strong>The Password. </li>
                <li><strong>Authentication Method</strong>: The SMTP client authentication method.</li>
                <li><strong>From Email: </strong>The author of this message. </li>
                <li><strong>To Email: </strong>The recipient of the message. </li>
                <li><strong>Subject: </strong>The subject of the message. </li>
                <li><strong>Content: </strong>The content of the message. </li>
                <li>Click on the <strong>Send</strong> button to send the message.</li>
            </ul>
            <div class="content">
                <table border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Smtp Server:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtServer" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfv" runat="server" CssClass="error-1" ErrorMessage="Smtp server Address is required"
                                ControlToValidate="txtServer" Display="Dynamic"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Smtp Port:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtPort" runat="server" CssClass="textbox" Width="50px">25</asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvPort" runat="server" CssClass="error-1" ErrorMessage="Smtp port is required"
                                ControlToValidate="txtPort" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RangeValidator ID="rvPort" runat="server" CssClass="error-1" ControlToValidate="txtPort"
                                ErrorMessage="Smtp Port is invalid" MaximumValue="65535" MinimumValue="1" Type="Integer"></asp:RangeValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Security Mode:</td>
                        <td width="100%">
                            <asp:DropDownList ID="ddlSecurityMode" runat="server" CssClass="dropdown" Width="200px">
                                <asp:ListItem>Unsecure</asp:ListItem>
                                <asp:ListItem>Implicit</asp:ListItem>
                                <asp:ListItem>Explicit</asp:ListItem>
                            </asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Smtp User:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtUser" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Password:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtPassword" runat="server" CssClass="textbox" Width="200px" TextMode="Password"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Authentication Method:</td>
                        <td width="100%">
                            <asp:DropDownList ID="ddlAuthentication" runat="server" CssClass="dropdown" Width="200px">
                            </asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>From Email:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtFrom" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvFrom" runat="server" CssClass="error-1" ErrorMessage="From email is required"
                                ControlToValidate="txtFrom" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="revFrom" runat="server" ControlToValidate="txtFrom"
                                CssClass="error-1" Display="Dynamic" ErrorMessage="From Email is invalid" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:RegularExpressionValidator></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>To Email:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtTo" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvTo" runat="server" CssClass="error-1" ErrorMessage="To email is required"
                                ControlToValidate="txtTo" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ControlToValidate="txtTo"
                                CssClass="error-1" Display="Dynamic" ErrorMessage="To Email is invalid" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:RegularExpressionValidator></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Subject:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtSubject" runat="server" CssClass="textbox" Width="300px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Content:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtContent" runat="server" CssClass="textbox" Width="300px" Height="200px"
                                TextMode="MultiLine"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <asp:Label ID="lblResult" runat="server" CssClass="bodytext"></asp:Label></td>
                    </tr>
                    <tr>
                        <td></td><td>
                            <asp:Button CssClass="button" ID="btnSend" runat="server" Text="Send" OnClick="btnSend_Click" /></td>
                    </tr>
                </table>
            </div>
        </div>
    </form>
</body>
</html>
