using System;
using System.Text;
using System.Web.UI.WebControls;
using ComponentPro.Net;
using ComponentPro.Net.Mail;

public partial class _Default : System.Web.UI.Page 
{
    void PopulateEnum()
    {
        Pop3AuthenticationMethod[] arr = (Pop3AuthenticationMethod[])Enum.GetValues(typeof(Pop3AuthenticationMethod));

        for (int i = 0; i < arr.Length; i++)
        {
            ddlAuthentication.Items.Add(new ListItem(arr[i].ToString(), ((int)arr[i]).ToString()));
        }

        int index;
        if (int.TryParse(Request.Form["ddlAuthentication"], out index))
            ddlAuthentication.SelectedIndex = index;
    }

    public _Default()
    {
        ComponentPro.Security.SecuritySettings.MediumTrust = true;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        PopulateEnum();
    }

    /// <summary>
    /// Handles the Download button's Click event.
    /// </summary>
    /// <param name="sender">The button object.</param>
    /// <param name="e">The event arguments.</param>
    protected void btnDownload_Click(object sender, EventArgs e)
    {
        // Create a new instance of the Pop3Client class.
        Pop3 client = new Pop3();

        try
        {
            string mailsPath = AppDomain.CurrentDomain.BaseDirectory + "Mails\\";

            // Create Mails folder to store downloaded messages if it does not exist.
            if (!System.IO.Directory.Exists(mailsPath))
                System.IO.Directory.CreateDirectory(mailsPath);

            StringBuilder sb = new StringBuilder();
            int port = int.Parse(txtPort.Text);

            // Connect to the server.
            client.Connect(txtServer.Text, port, (SecurityMode)ddlSecurityMode.SelectedIndex);

            // Login to the server.
            Pop3AuthenticationMethod ia = (Pop3AuthenticationMethod)int.Parse(ddlAuthentication.SelectedValue);
            client.Authenticate(txtUser.Text, txtPassword.Text, ia);

            // Retrieve a list of message with unique id and sequence number.
            Pop3MessageCollection list = client.ListMessages(Pop3EnvelopeParts.UniqueId | Pop3EnvelopeParts.MessageInboxIndex);
            int messages = int.Parse(txtMessages.Text);
            if (list.Count < messages)
                messages = list.Count;

            Pop3Message message;
            for (int i = 0; i < messages; i++)
            {
                message = list[i];

                // Get file name.
                string filename = mailsPath + GetFilename(message.UniqueId) + ".eml";

                // Get new message only.
                if (!System.IO.File.Exists(filename))
                {
                    client.DownloadMessage(message.MessageInboxIndex, filename);
                    sb.AppendFormat("Message {0} downloaded<br>", message.UniqueId);
                }
            }

            sb.AppendFormat("{0} message(s) have been downloaded successfully!", messages);
            lblResult.Text = sb.ToString();
        }
        catch (Exception exc)
        {
            lblResult.Text = string.Format(null, "Exception: {0}", exc.Message);
        }
        finally
        {
            // Disconnect.
            client.Disconnect();            
        }
    }

    /// <summary>
    /// Returns a uniquely correct file name from the specified unique message ID.
    /// </summary>
    /// <param name="uniqueId">The unique id.</param>
    /// <returns>The corrected file name.</returns>
    private static string GetFilename(string uniqueId)
    {
        // Characters allowed in the filename
        //string allowed = " .-0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";            
        const string allowed = " .-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";

        // Replace invalid charactes with its hex representation
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < uniqueId.Length; i++)
        {
            if (allowed.IndexOf(uniqueId[i]) < 0)
                sb.AppendFormat("_{0:X2}", (int)uniqueId[i]);
            else
                sb.Append(uniqueId[i]);
        }
        return sb.ToString();
    }
}