﻿Imports System.Text
Imports ComponentPro.Net
Imports ComponentPro

Namespace EmailValidatorDemo
	''' <summary>
	''' Interaction logic for Main.xaml
	''' </summary>
	Partial Public Class Main
		Inherits Window
		Public Sub New()
			InitializeComponent()

			AddHandler emailValidator.ValidateCompleted, AddressOf emailValidator_ValidateCompleted
			AddHandler emailValidator.MessageLogging, AddressOf emailValidator_MessageLogging
			AddHandler emailValidator.EmailValidated, AddressOf emailValidator_EmailValidated
		End Sub

		Private Sub emailValidator_EmailValidated(ByVal sender As Object, ByVal e As EmailValidatedEventArgs)
			Dispatcher.Invoke(New EventHandler(Of EmailValidatedEventArgs)(AddressOf EmailValidated), sender, e)
		End Sub

		Private Sub EmailValidated(ByVal sender As Object, ByVal e As EmailValidatedEventArgs)
			If e.Error IsNot Nothing Then
				lst1AdvancedLog.Items.Add(String.Format("Email '{0}' validated at level {1} with error: {2}.", e.EmailAddress, e.ValidatedLevel, e.Error.Message))
			Else
				lst1AdvancedLog.Items.Add(String.Format("Email '{0}' validated at level {1}.", e.EmailAddress, e.ValidatedLevel))
			End If
		End Sub

		Private emailValidator As New EmailValidator()

		Private Sub EnableSingleMode(ByVal enable As Boolean)
			txtEmailSingle.IsEnabled = enable
			If enable Then
				btnValidateSingle.Content = "Validate"
			Else
				btnValidateSingle.Content = "Stop"
			End If
			If enable Then
				btnValidateSingle.IsEnabled = True
			End If
		End Sub

		Private Sub btnVerify_Click(ByVal sender As Object, ByVal e As RoutedEventArgs)
			' Is not validating?
			If CStr(btnValidateSingle.Content) = "Validate" Then
				' Clear logs.
				lst1AdvancedLog.Items.Clear()
				Try
					EnableSingleMode(False)

					' Asynchronously validate a single email.
                    emailValidator.ValidateAsync(txtEmailSingle.Text)
				Catch exc As Exception
					MessageBox.Show(exc.Message, "Error", MessageBoxButton.OK, MessageBoxImage.Stop)
					EnableSingleMode(True)
				End Try
			Else
				' Abort the validation.
				btnValidateSingle.IsEnabled = False
				emailValidator.Cancel()
			End If
		End Sub

		Private Sub emailValidator_MessageLogging(ByVal sender As Object, ByVal e As EmailValidatorLogEventArgs)
			Dispatcher.Invoke(New EventHandler(Of EmailValidatorLogEventArgs)(AddressOf MessageLogging), sender, e)
		End Sub

		''' <summary>
		''' Handles the emailvalidator's MessageLogging event.
		''' </summary>
		''' <param name="sender">The emailvalidator object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub MessageLogging(ByVal sender As Object, ByVal e As ComponentPro.Net.EmailValidatorLogEventArgs)
			Dim msg As String = e.SmtpTranscript.Replace(vbCrLf, String.Empty)

			lst1AdvancedLog.Items.Add(msg)
		End Sub

        Private Sub emailValidator_ValidateCompleted(ByVal sender As Object, ByVal e As ExtendedAsyncCompletedEventArgs(Of ValidationLevel))
            If e.Error IsNot Nothing Then
                System.Windows.MessageBox.Show("Error: " & e.Error.Message, "Error", MessageBoxButton.OK, MessageBoxImage.Stop)
            Else
                ' Get the validation result.
                Dim level As ValidationLevel = e.Result

                MessageBox.Show("E-mail address validation completed at level: " & level.ToString(), "Email Validator Demo", MessageBoxButton.OK, MessageBoxImage.Information)
            End If

            EnableSingleMode(True)
        End Sub

        Public Shared Sub ShowError(ByVal exc As Exception)
            Dim str As String

            If exc.InnerException IsNot Nothing Then
                str = String.Format(Nothing, "An error occurred: {0}", exc.InnerException.Message)
            Else
                str = String.Format(Nothing, "An error occurred: {0}", exc.Message)
            End If

            MessageBox.Show(str, "Error")
        End Sub
    End Class
End Namespace
