Imports ComponentPro.Net.Mail

Namespace EmailValidatorDemo
	Partial Public Class ProxySettings
		Inherits Form
		Private _proxyServer As String
		Private _userName As String
		Private _password As String
		Private _domain As String
		Private _port As Integer
		Private _authenticationMethod As ProxyHttpConnectAuthMethod
		Private _type As ProxyType

		Public Sub New()
			InitializeComponent()
		End Sub

		''' <summary>
		''' Handles the OK button's Click.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnOK_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnOK.Click
			' The provided proxy port is correct?
			If txtProxyPort.Text.Length > 0 Then
				Try
					Dim serverport As Integer = Integer.Parse(txtProxyPort.Text)
					If serverport < 1 OrElse serverport > 65535 Then
						MessageBox.Show("Invalid port number, must be between 1 and 65535")
						Return
					End If
					_port = serverport
				Catch exc As Exception
					MessageBox.Show("Invalid port: " & exc.Message)
					Return
				End Try
			End If

			If txtPassword.Text.Length > 0 AndAlso txtUserName.Text.Length = 0 Then
				MessageBox.Show("Please enter user name")
				Return
			End If

			_proxyServer = txtProxyHost.Text
			_type = CType(cbxType.SelectedIndex, ProxyType)
			_authenticationMethod = CType(cbxMethod.SelectedIndex, ProxyHttpConnectAuthMethod)
			_userName = txtUserName.Text
			_password = txtPassword.Text
			_domain = txtDomain.Text

			Me.DialogResult = System.Windows.Forms.DialogResult.OK
		End Sub

		Public Property ProxyServer() As String
			Get
				Return _proxyServer
			End Get
			Set(ByVal value As String)
				_proxyServer = value
			End Set
		End Property

		Public Property UserName() As String
			Get
				Return _userName
			End Get
			Set(ByVal value As String)
				_userName = value
			End Set
		End Property

		Public Property Password() As String
			Get
				Return _password
			End Get
			Set(ByVal value As String)
				_password = value
			End Set
		End Property

		Public Property Domain() As String
			Get
				Return _domain
			End Get
			Set(ByVal value As String)
				_domain = value
			End Set
		End Property

		Public Property Port() As Integer
			Get
				Return _port
			End Get
			Set(ByVal value As Integer)
				_port = value
			End Set
		End Property

		Public Property AuthenticationMethod() As ProxyHttpConnectAuthMethod
			Get
				Return _authenticationMethod
			End Get
			Set(ByVal value As ProxyHttpConnectAuthMethod)
				_authenticationMethod = value
			End Set
		End Property

		Public Property Type() As ProxyType
			Get
				Return _type
			End Get
			Set(ByVal value As ProxyType)
				_type = value
			End Set
		End Property

		Private Sub ProxySettings_Load(ByVal sender As Object, ByVal e As EventArgs) Handles MyBase.Load
			' Load settings.
			txtUserName.Text = _userName
			txtPassword.Text = _password
			txtDomain.Text = _domain
			txtProxyHost.Text = _proxyServer
			If _port > 0 Then
				txtProxyPort.Text = _port.ToString()
			End If
			cbxMethod.SelectedIndex = CInt(Fix(_authenticationMethod))
			cbxType.SelectedIndex = CInt(Fix(_type))
		End Sub

		''' <summary>
		''' Handles the combo box proxy type's SelectedIndexChanged event.
		''' </summary>
		''' <param name="sender">The combo box.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub cbx_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs) Handles cbxMethod.SelectedIndexChanged, cbxType.SelectedIndexChanged
			Dim enable As Boolean = cbxType.SelectedIndex > 0

			cbxMethod.Enabled = cbxType.SelectedIndex = CInt(Fix(ProxyType.HttpConnect)) ' Authentication method is available for HTTP Connect only.
			txtDomain.Enabled = cbxMethod.Enabled AndAlso cbxMethod.SelectedIndex = CInt(Fix(ProxyHttpConnectAuthMethod.Ntlm)) ' Domain is available for NTLM authentication method only.
			txtUserName.Enabled = enable ' User name and password are ignored with SendToProxy proxy type. -  && cbxType.SelectedIndex != (int)ProxyType.SendToProxy
			txtPassword.Enabled = enable ' && cbxType.SelectedIndex != (int)ProxyType.SendToProxy
			txtProxyHost.Enabled = enable ' Proxy host and port are not available in NoProxy type.
			txtProxyPort.Enabled = enable
		End Sub
	End Class
End Namespace