Namespace EmailValidatorDemo
	Public Class IPAddressForm
		Inherits System.Windows.Forms.Form
		Private panel As System.Windows.Forms.Panel
		Private WithEvents txtIPa As System.Windows.Forms.TextBox
		Private WithEvents txtIPb As System.Windows.Forms.TextBox
		Private WithEvents txtIPc As System.Windows.Forms.TextBox
		Private WithEvents txtIPd As System.Windows.Forms.TextBox
		Private lblIPDot1 As System.Windows.Forms.Label
		Private lblIPDot2 As System.Windows.Forms.Label
		Private lblIPDot3 As System.Windows.Forms.Label
		Private WithEvents cmdOK As System.Windows.Forms.Button
		Private cmdCancel As System.Windows.Forms.Button

		Private ReadOnly components As System.ComponentModel.Container
		Private ReadOnly _addressToEdit As String = ""
		Private lblHelp As System.Windows.Forms.Label
		Private _addressToReturn As String = ""

		Public Sub New(ByVal addressToEdit As String)
			_addressToEdit = addressToEdit
			InitializeComponent()
		End Sub

		Public Sub New()
			InitializeComponent()
		End Sub

		''' <summary>
		''' Gets the IP address.
		''' </summary>
		Public ReadOnly Property Address() As String
			Get
				Return _addressToReturn
			End Get
		End Property
		Protected Overrides Sub Dispose(ByVal disposing As Boolean)
			If disposing Then
				If components IsNot Nothing Then
					components.Dispose()
				End If
			End If
			MyBase.Dispose(disposing)
		End Sub

		#Region "Windows Form Designer generated code"

		Private Sub InitializeComponent()
			Me.panel = New System.Windows.Forms.Panel()
			Me.lblIPDot3 = New System.Windows.Forms.Label()
			Me.lblIPDot2 = New System.Windows.Forms.Label()
			Me.lblIPDot1 = New System.Windows.Forms.Label()
			Me.txtIPd = New System.Windows.Forms.TextBox()
			Me.txtIPc = New System.Windows.Forms.TextBox()
			Me.txtIPb = New System.Windows.Forms.TextBox()
			Me.txtIPa = New System.Windows.Forms.TextBox()
			Me.cmdOK = New System.Windows.Forms.Button()
			Me.cmdCancel = New System.Windows.Forms.Button()
			Me.lblHelp = New System.Windows.Forms.Label()
			Me.panel.SuspendLayout()
			Me.SuspendLayout()
			' 
			' panel
			' 
			Me.panel.BackColor = System.Drawing.SystemColors.Window
			Me.panel.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle
			Me.panel.Controls.Add(Me.lblIPDot3)
			Me.panel.Controls.Add(Me.lblIPDot2)
			Me.panel.Controls.Add(Me.lblIPDot1)
			Me.panel.Controls.Add(Me.txtIPd)
			Me.panel.Controls.Add(Me.txtIPc)
			Me.panel.Controls.Add(Me.txtIPb)
			Me.panel.Controls.Add(Me.txtIPa)
			Me.panel.Location = New System.Drawing.Point(11, 28)
			Me.panel.Name = "panel"
			Me.panel.Size = New System.Drawing.Size(152, 24)
			Me.panel.TabIndex = 0
			' 
			' lblIPDot3
			' 
			Me.lblIPDot3.AutoSize = True
			Me.lblIPDot3.Location = New System.Drawing.Point(109, 4)
			Me.lblIPDot3.Name = "lblIPDot3"
			Me.lblIPDot3.Size = New System.Drawing.Size(10, 13)
			Me.lblIPDot3.TabIndex = 6
			Me.lblIPDot3.Text = "."
			' 
			' lblIPDot2
			' 
			Me.lblIPDot2.AutoSize = True
			Me.lblIPDot2.Location = New System.Drawing.Point(72, 4)
			Me.lblIPDot2.Name = "lblIPDot2"
			Me.lblIPDot2.Size = New System.Drawing.Size(10, 13)
			Me.lblIPDot2.TabIndex = 5
			Me.lblIPDot2.Text = "."
			' 
			' lblIPDot1
			' 
			Me.lblIPDot1.AutoSize = True
			Me.lblIPDot1.Location = New System.Drawing.Point(35, 4)
			Me.lblIPDot1.Name = "lblIPDot1"
			Me.lblIPDot1.Size = New System.Drawing.Size(10, 13)
			Me.lblIPDot1.TabIndex = 4
			Me.lblIPDot1.Text = "."
			' 
			' txtIPd
			' 
			Me.txtIPd.BorderStyle = System.Windows.Forms.BorderStyle.None
			Me.txtIPd.Location = New System.Drawing.Point(119, 4)
			Me.txtIPd.MaxLength = 3
			Me.txtIPd.Name = "txtIPd"
			Me.txtIPd.Size = New System.Drawing.Size(24, 13)
			Me.txtIPd.TabIndex = 3
			Me.txtIPd.Text = "255"
'			Me.txtIPd.KeyUp += New System.Windows.Forms.KeyEventHandler(Me.txtIP_KeyUp)
'			Me.txtIPd.KeyPress += New System.Windows.Forms.KeyPressEventHandler(Me.txtIP_KeyPress)
'			Me.txtIPd.Enter += New System.EventHandler(Me.TextBox_Enter)
			' 
			' txtIPc
			' 
			Me.txtIPc.BorderStyle = System.Windows.Forms.BorderStyle.None
			Me.txtIPc.Location = New System.Drawing.Point(82, 4)
			Me.txtIPc.MaxLength = 3
			Me.txtIPc.Name = "txtIPc"
			Me.txtIPc.Size = New System.Drawing.Size(24, 13)
			Me.txtIPc.TabIndex = 2
			Me.txtIPc.Text = "255"
'			Me.txtIPc.KeyUp += New System.Windows.Forms.KeyEventHandler(Me.txtIP_KeyUp)
'			Me.txtIPc.KeyPress += New System.Windows.Forms.KeyPressEventHandler(Me.txtIP_KeyPress)
'			Me.txtIPc.Enter += New System.EventHandler(Me.TextBox_Enter)
			' 
			' txtIPb
			' 
			Me.txtIPb.BorderStyle = System.Windows.Forms.BorderStyle.None
			Me.txtIPb.Location = New System.Drawing.Point(45, 4)
			Me.txtIPb.MaxLength = 3
			Me.txtIPb.Name = "txtIPb"
			Me.txtIPb.Size = New System.Drawing.Size(24, 13)
			Me.txtIPb.TabIndex = 1
			Me.txtIPb.Text = "255"
'			Me.txtIPb.KeyUp += New System.Windows.Forms.KeyEventHandler(Me.txtIP_KeyUp)
'			Me.txtIPb.KeyPress += New System.Windows.Forms.KeyPressEventHandler(Me.txtIP_KeyPress)
'			Me.txtIPb.Enter += New System.EventHandler(Me.TextBox_Enter)
			' 
			' txtIPa
			' 
			Me.txtIPa.BorderStyle = System.Windows.Forms.BorderStyle.None
			Me.txtIPa.Location = New System.Drawing.Point(8, 4)
			Me.txtIPa.MaxLength = 3
			Me.txtIPa.Name = "txtIPa"
			Me.txtIPa.Size = New System.Drawing.Size(24, 13)
			Me.txtIPa.TabIndex = 0
			Me.txtIPa.Text = "255"
'			Me.txtIPa.KeyUp += New System.Windows.Forms.KeyEventHandler(Me.txtIP_KeyUp)
'			Me.txtIPa.KeyPress += New System.Windows.Forms.KeyPressEventHandler(Me.txtIP_KeyPress)
'			Me.txtIPa.Enter += New System.EventHandler(Me.TextBox_Enter)
			' 
			' cmdOK
			' 
			Me.cmdOK.Location = New System.Drawing.Point(21, 58)
			Me.cmdOK.Name = "cmdOK"
			Me.cmdOK.Size = New System.Drawing.Size(74, 23)
			Me.cmdOK.TabIndex = 1
			Me.cmdOK.Text = "OK"
'			Me.cmdOK.Click += New System.EventHandler(Me.cmdOK_Click)
			' 
			' cmdCancel
			' 
			Me.cmdCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel
			Me.cmdCancel.Location = New System.Drawing.Point(100, 58)
			Me.cmdCancel.Name = "cmdCancel"
			Me.cmdCancel.Size = New System.Drawing.Size(64, 23)
			Me.cmdCancel.TabIndex = 2
			Me.cmdCancel.Text = "Cancel"
			' 
			' lblHelp
			' 
			Me.lblHelp.AutoSize = True
			Me.lblHelp.Location = New System.Drawing.Point(8, 8)
			Me.lblHelp.Name = "lblHelp"
			Me.lblHelp.Size = New System.Drawing.Size(123, 13)
			Me.lblHelp.TabIndex = 3
			Me.lblHelp.Text = "Please enter IP Address:"
			' 
			' IPAddressForm
			' 
			Me.AcceptButton = Me.cmdOK
			Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
			Me.CancelButton = Me.cmdCancel
			Me.ClientSize = New System.Drawing.Size(172, 91)
			Me.Controls.Add(Me.lblHelp)
			Me.Controls.Add(Me.cmdCancel)
			Me.Controls.Add(Me.cmdOK)
			Me.Controls.Add(Me.panel)
			Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog
			Me.MaximizeBox = False
			Me.MinimizeBox = False
			Me.Name = "IPAddressForm"
			Me.ShowInTaskbar = False
			Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent
			Me.Text = "IP Address"
'			Me.Load += New System.EventHandler(Me.IPEntryDialog_Load)
			Me.panel.ResumeLayout(False)
			Me.panel.PerformLayout()
			Me.ResumeLayout(False)
			Me.PerformLayout()

		End Sub
		#End Region

		''' <summary>
		''' Handles the ip text box's KeyPress event.
		''' </summary>
		''' <param name="sender">The ip textbox object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub txtIP_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtIPd.KeyPress, txtIPc.KeyPress, txtIPb.KeyPress, txtIPa.KeyPress
			Dim box As TextBox = CType(sender, TextBox)

			' Allow backspace
			If AscW(e.KeyChar) = 8 Then
				Return
			End If

			' Attempt to convert to decimal number, if failure, don't allow key to show
			Dim n As Integer

			Try
				Convert.ToInt32(e.KeyChar.ToString())
			Catch e1 As FormatException
				e.Handled = True
				Return
			End Try

			Dim newNum As String = box.Text & e.KeyChar
			If newNum.Length > 3 Then
				newNum = e.KeyChar.ToString()
			End If

			Try
				n = Convert.ToInt32(newNum)
			Catch e2 As FormatException
				n = -1
			End Try

			Dim nMax As Integer = 255
			Dim nMin As Integer = 0
			If box.Name = "txtIPa" Then
				nMax = 223
				nMin = 1
			End If

			' Validate the typed text.
			If n > nMax Then
				MessageBox.Show(n & " is not a valid entry. Please specify a value between " & nMin & " and " & nMax, "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning)
				box.Text = nMax.ToString()
				box.Focus()
			ElseIf n < nMin Then
				MessageBox.Show(n & " is not a valid entry. Please specify a value between " & nMin & " and " & nMax, "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning)
				txtIPa.Text = "1"
				txtIPa.Focus()
			End If
		End Sub

		''' <summary>
		''' Handles the IP textbox's KeyUp event.
		''' </summary>
		''' <param name="sender">The IP textbox object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub txtIP_KeyUp(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles txtIPd.KeyUp, txtIPc.KeyUp, txtIPb.KeyUp, txtIPa.KeyUp
			Dim box As TextBox = CType(sender, TextBox)

			' No longer than 3 characters.
			If box.SelectionStart <> 3 Then
				Return
			End If

			Select Case box.Name
				Case "txtIPa"
					txtIPb.Focus()
				Case "txtIPb"
					txtIPc.Focus()
				Case "txtIPc"
					txtIPd.Focus()
				Case "txtIPd"
					cmdOK.Focus()
			End Select
		End Sub

		''' <summary>
		''' Handles the textbox's Enter event.
		''' </summary>
		''' <param name="sender">The textbox object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub TextBox_Enter(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtIPd.Enter, txtIPc.Enter, txtIPb.Enter, txtIPa.Enter
			Dim box As TextBox = CType(sender, TextBox)
			box.SelectionStart = 0
			box.SelectionLength = box.Text.Length
		End Sub

		''' <summary>
		''' Handles the OK button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub cmdOK_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles cmdOK.Click
			' Build up an IP address string.
			Dim s As String = txtIPa.Text & "." & txtIPb.Text & "." & txtIPc.Text & "." & txtIPd.Text
			Try
				' Make sure all four IPa,b,c,d are correct.
				_addressToReturn = Convert.ToInt32(txtIPa.Text) & "." & Convert.ToInt32(txtIPb.Text) & "." & Convert.ToInt32(txtIPc.Text) & "." & Convert.ToInt32(txtIPd.Text)
				DialogResult = System.Windows.Forms.DialogResult.OK
			Catch e1 As FormatException
				MessageBox.Show("'" & s & "' is not a valid IP Address!", "Error")
			End Try
		End Sub

		''' <summary>
		''' Handles the form's Load event.
		''' </summary>
		''' <param name="sender">The form object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub IPEntryDialog_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
			' Load and fill in all text boxes.
			If String.IsNullOrEmpty(_addressToEdit) Then
				txtIPd.Text = ""
				txtIPc.Text = txtIPd.Text
				txtIPb.Text = txtIPc.Text
				txtIPa.Text = txtIPb.Text
				Me.Text = "Add IP Address"
			Else
				Dim parts() As String = _addressToEdit.Split("."c)

				If parts.Length = 4 Then
					txtIPa.Text = parts(0)
					txtIPb.Text = parts(1)
					txtIPc.Text = parts(2)
					txtIPd.Text = parts(3)
				End If

				Me.Text = "Edit IP Address"
			End If
		End Sub
	End Class
End Namespace