using System;
using System.Windows.Forms;
using ComponentPro.Net;

namespace EmailValidatorDemo
{
    public class SettingsDialog : System.Windows.Forms.Form
    {
        private System.Windows.Forms.Button cmdOK;
        private System.Windows.Forms.Button cmdCancel;
        private System.Windows.Forms.TextBox txtMailFrom;
        private System.Windows.Forms.Label lblMailFrom;
        private System.Windows.Forms.Label lblDnsServer;
        private System.Windows.Forms.Label lblValidationLevel;
        private System.Windows.Forms.ComboBox cboValidationLevel;
        private System.Windows.Forms.TextBox txtBlackList;
        private System.Windows.Forms.TextBox txtWhiteList;
        private System.Windows.Forms.Label lblWhiteList;
        private System.Windows.Forms.Label lblBlackList;
        private System.Windows.Forms.Button cmdWhiteListBrowse;
        private System.Windows.Forms.Button cmdBlackListBrowse;
        private System.Windows.Forms.ListBox lbxDnsServers;
        private System.Windows.Forms.Button cmdDnsServerAdd;
        private System.Windows.Forms.Button cmdDnsServerEdit;
        private System.Windows.Forms.Button cmdDnsServerRemove;
        private readonly System.ComponentModel.Container components = null;

        private GroupBox smtpSettings;
        private GroupBox dnsSettings;
        private System.Windows.Forms.TextBox txtDnsTimeout;
        private System.Windows.Forms.CheckBox chkRandomDns;
        private System.Windows.Forms.Label lblDnsTimeout;
        private System.Windows.Forms.Label lbMs;
        private System.Windows.Forms.Label lbMs1;
        private System.Windows.Forms.Label lblSmtpTimeout;
        private System.Windows.Forms.TextBox txtSmtpTimeout;
        private System.Windows.Forms.Label lblSmtpPort;
        private System.Windows.Forms.TextBox txtSmtpPort;
        private System.Windows.Forms.Label lblFromDomain;
        private System.Windows.Forms.TextBox txtFromDomain;
        private GroupBox blackwhiteLists;
        private GroupBox general;
        private System.Windows.Forms.TextBox txtSyntaxPattern;
        private System.Windows.Forms.Label lblEmailSyntaxPattern;
        private System.Windows.Forms.CheckBox chkCacheMXRecords;
        private System.Windows.Forms.Label lbMs2;
        private System.Windows.Forms.Label lblCacheTimeout;
        private System.Windows.Forms.TextBox txtCacheTimeout;
        private System.Windows.Forms.CheckBox chkDeepCheck;
        private readonly EmailValidator _validator;

        public SettingsDialog(EmailValidator validator, string whiteListFile, string blackListFile)
        {
            _validator = validator;
            InitializeComponent();

            // Smtp
            txtMailFrom.Text = validator.SmtpFromEmail;
            txtFromDomain.Text = validator.SmtpHeloDomain;
            txtSmtpPort.Text = validator.SmtpPort.ToString();
            txtSmtpTimeout.Text = validator.SmtpTimeout.ToString();

            // Dns
            txtDnsTimeout.Text = validator.DnsTimeout.ToString();
            chkRandomDns.Checked = validator.UseRandomDnsServer;
            foreach (string str in validator.DnsServers)
                lbxDnsServers.Items.Add(str);

            txtWhiteList.Text = whiteListFile;
            txtBlackList.Text = blackListFile;

            switch (validator.ValidationLevel)
            {
                case ValidationLevel.Syntax:
                    cboValidationLevel.SelectedIndex = 0;
                    break;

                case ValidationLevel.Lists:
                    cboValidationLevel.SelectedIndex = 1;
                    break;

                case ValidationLevel.MailExchangeRecords:
                    cboValidationLevel.SelectedIndex = 2;
                    break;

                case ValidationLevel.SmtpConnection:
                    cboValidationLevel.SelectedIndex = 3;
                    break;

                case ValidationLevel.Mailbox:
                    cboValidationLevel.SelectedIndex = 4;
                    break;
            }

            chkCacheMXRecords.Checked = validator.UseMailExchangeRecordCache;
            chkDeepCheck.Checked = validator.DeepMailboxCheck;
            txtSyntaxPattern.Text = validator.EmailSyntaxPattern;
            txtCacheTimeout.Text = validator.MailExchangeRecordCacheTimeout.ToString();
        }

        #region Properties

        /// <summary>
        /// Gets the white list file.
        /// </summary>
        public string WhiteListFile
        {
            get
            {
                return txtWhiteList.Text;
            }
        }

        /// <summary>
        /// Gets the black list file.
        /// </summary>
        public string BlackListFile
        {
            get
            {
                return txtBlackList.Text;
            }
        }

        #endregion

        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region Windows Form Designer generated code
        /// <summary>
        /// Required method for Designer support - do not modify
        /// the contents of this method with the code editor.
        /// </summary>
        private void InitializeComponent()
        {
            this.cmdOK = new System.Windows.Forms.Button();
            this.cmdCancel = new System.Windows.Forms.Button();
            this.txtMailFrom = new System.Windows.Forms.TextBox();
            this.lblMailFrom = new System.Windows.Forms.Label();
            this.lblDnsServer = new System.Windows.Forms.Label();
            this.lblValidationLevel = new System.Windows.Forms.Label();
            this.cboValidationLevel = new System.Windows.Forms.ComboBox();
            this.txtBlackList = new System.Windows.Forms.TextBox();
            this.txtWhiteList = new System.Windows.Forms.TextBox();
            this.lblWhiteList = new System.Windows.Forms.Label();
            this.lblBlackList = new System.Windows.Forms.Label();
            this.cmdWhiteListBrowse = new System.Windows.Forms.Button();
            this.cmdBlackListBrowse = new System.Windows.Forms.Button();
            this.lbxDnsServers = new System.Windows.Forms.ListBox();
            this.cmdDnsServerAdd = new System.Windows.Forms.Button();
            this.cmdDnsServerEdit = new System.Windows.Forms.Button();
            this.cmdDnsServerRemove = new System.Windows.Forms.Button();
            this.smtpSettings = new System.Windows.Forms.GroupBox();
            this.lbMs1 = new System.Windows.Forms.Label();
            this.lblSmtpTimeout = new System.Windows.Forms.Label();
            this.txtSmtpTimeout = new System.Windows.Forms.TextBox();
            this.lblSmtpPort = new System.Windows.Forms.Label();
            this.txtSmtpPort = new System.Windows.Forms.TextBox();
            this.lblFromDomain = new System.Windows.Forms.Label();
            this.txtFromDomain = new System.Windows.Forms.TextBox();
            this.dnsSettings = new System.Windows.Forms.GroupBox();
            this.lblDnsTimeout = new System.Windows.Forms.Label();
            this.lbMs = new System.Windows.Forms.Label();
            this.txtDnsTimeout = new System.Windows.Forms.TextBox();
            this.chkRandomDns = new System.Windows.Forms.CheckBox();
            this.blackwhiteLists = new System.Windows.Forms.GroupBox();
            this.general = new System.Windows.Forms.GroupBox();
            this.chkDeepCheck = new System.Windows.Forms.CheckBox();
            this.lbMs2 = new System.Windows.Forms.Label();
            this.lblCacheTimeout = new System.Windows.Forms.Label();
            this.txtCacheTimeout = new System.Windows.Forms.TextBox();
            this.chkCacheMXRecords = new System.Windows.Forms.CheckBox();
            this.txtSyntaxPattern = new System.Windows.Forms.TextBox();
            this.lblEmailSyntaxPattern = new System.Windows.Forms.Label();
            this.smtpSettings.SuspendLayout();
            this.dnsSettings.SuspendLayout();
            this.blackwhiteLists.SuspendLayout();
            this.general.SuspendLayout();
            this.SuspendLayout();
            // 
            // cmdOK
            // 
            this.cmdOK.Location = new System.Drawing.Point(443, 328);
            this.cmdOK.Name = "cmdOK";
            this.cmdOK.Size = new System.Drawing.Size(75, 23);
            this.cmdOK.TabIndex = 30;
            this.cmdOK.Text = "OK";
            this.cmdOK.Click += new System.EventHandler(this.cmdOK_Click);
            // 
            // cmdCancel
            // 
            this.cmdCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.cmdCancel.Location = new System.Drawing.Point(523, 328);
            this.cmdCancel.Name = "cmdCancel";
            this.cmdCancel.Size = new System.Drawing.Size(75, 23);
            this.cmdCancel.TabIndex = 31;
            this.cmdCancel.Text = "Cancel";
            // 
            // txtMailFrom
            // 
            this.txtMailFrom.Location = new System.Drawing.Point(88, 19);
            this.txtMailFrom.Name = "txtMailFrom";
            this.txtMailFrom.Size = new System.Drawing.Size(169, 21);
            this.txtMailFrom.TabIndex = 0;
            this.txtMailFrom.Enter += new System.EventHandler(this.TextBox_Enter);
            // 
            // lblMailFrom
            // 
            this.lblMailFrom.Location = new System.Drawing.Point(10, 22);
            this.lblMailFrom.Name = "lblMailFrom";
            this.lblMailFrom.Size = new System.Drawing.Size(55, 13);
            this.lblMailFrom.TabIndex = 5;
            this.lblMailFrom.Text = "Mail From:";
            // 
            // lblDnsServer
            // 
            this.lblDnsServer.Location = new System.Drawing.Point(6, 19);
            this.lblDnsServer.Name = "lblDnsServer";
            this.lblDnsServer.Size = new System.Drawing.Size(68, 13);
            this.lblDnsServer.TabIndex = 6;
            this.lblDnsServer.Text = "Dns Servers:";
            // 
            // lblValidationLevel
            // 
            this.lblValidationLevel.Location = new System.Drawing.Point(10, 16);
            this.lblValidationLevel.Name = "lblValidationLevel";
            this.lblValidationLevel.Size = new System.Drawing.Size(56, 26);
            this.lblValidationLevel.TabIndex = 42;
            this.lblValidationLevel.Text = "Validation \r\nLevel:";
            // 
            // cboValidationLevel
            // 
            this.cboValidationLevel.DrawMode = System.Windows.Forms.DrawMode.Normal;
            this.cboValidationLevel.DroppedDown = false;
            this.cboValidationLevel.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cboValidationLevel.FormatInfo = null;
            this.cboValidationLevel.FormatString = "";
            this.cboValidationLevel.FormattingEnabled = false;
            this.cboValidationLevel.Items.AddRange(new object[] {
            "Syntax",
            "Lists",
            "Mail Exchange Records",
            "Smtp Connection",
            "Mailbox"});
            this.cboValidationLevel.Location = new System.Drawing.Point(88, 16);
            this.cboValidationLevel.Name = "cboValidationLevel";
            this.cboValidationLevel.Size = new System.Drawing.Size(169, 21);
            this.cboValidationLevel.Sorted = false;
            this.cboValidationLevel.TabIndex = 15;
            // 
            // txtBlackList
            // 
            this.txtBlackList.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.txtBlackList.Location = new System.Drawing.Point(88, 45);
            this.txtBlackList.Name = "txtBlackList";
            this.txtBlackList.Size = new System.Drawing.Size(427, 21);
            this.txtBlackList.TabIndex = 13;
            this.txtBlackList.Enter += new System.EventHandler(this.TextBox_Enter);
            // 
            // txtWhiteList
            // 
            this.txtWhiteList.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                        | System.Windows.Forms.AnchorStyles.Right)));
            this.txtWhiteList.Location = new System.Drawing.Point(88, 19);
            this.txtWhiteList.Name = "txtWhiteList";
            this.txtWhiteList.Size = new System.Drawing.Size(427, 21);
            this.txtWhiteList.TabIndex = 11;
            this.txtWhiteList.Enter += new System.EventHandler(this.TextBox_Enter);
            // 
            // lblWhiteList
            // 
            this.lblWhiteList.Location = new System.Drawing.Point(10, 23);
            this.lblWhiteList.Name = "lblWhiteList";
            this.lblWhiteList.Size = new System.Drawing.Size(54, 13);
            this.lblWhiteList.TabIndex = 49;
            this.lblWhiteList.Text = "WhiteList:";
            // 
            // lblBlackList
            // 
            this.lblBlackList.Location = new System.Drawing.Point(10, 48);
            this.lblBlackList.Name = "lblBlackList";
            this.lblBlackList.Size = new System.Drawing.Size(53, 13);
            this.lblBlackList.TabIndex = 50;
            this.lblBlackList.Text = "BlackList:";
            // 
            // cmdWhiteListBrowse
            // 
            this.cmdWhiteListBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.cmdWhiteListBrowse.Location = new System.Drawing.Point(521, 19);
            this.cmdWhiteListBrowse.Name = "cmdWhiteListBrowse";
            this.cmdWhiteListBrowse.Size = new System.Drawing.Size(56, 20);
            this.cmdWhiteListBrowse.TabIndex = 12;
            this.cmdWhiteListBrowse.Text = "Browse";
            this.cmdWhiteListBrowse.Click += new System.EventHandler(this.cmdWhiteListBrowse_Click);
            // 
            // cmdBlackListBrowse
            // 
            this.cmdBlackListBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.cmdBlackListBrowse.Location = new System.Drawing.Point(521, 45);
            this.cmdBlackListBrowse.Name = "cmdBlackListBrowse";
            this.cmdBlackListBrowse.Size = new System.Drawing.Size(56, 20);
            this.cmdBlackListBrowse.TabIndex = 14;
            this.cmdBlackListBrowse.Text = "Browse";
            this.cmdBlackListBrowse.Click += new System.EventHandler(this.cmdBlackListBrowse_Click);
            // 
            // lbxDnsServers
            // 
            this.lbxDnsServers.Location = new System.Drawing.Point(78, 19);
            this.lbxDnsServers.Name = "lbxDnsServers";
            this.lbxDnsServers.Size = new System.Drawing.Size(162, 69);
            this.lbxDnsServers.TabIndex = 5;
            this.lbxDnsServers.SelectedIndexChanged += new System.EventHandler(this.lbxDnsServers_SelectedIndexChanged);
            this.lbxDnsServers.DoubleClick += new System.EventHandler(this.lbxDnsServers_DoubleClick);
            // 
            // cmdDnsServerAdd
            // 
            this.cmdDnsServerAdd.Location = new System.Drawing.Point(246, 19);
            this.cmdDnsServerAdd.Name = "cmdDnsServerAdd";
            this.cmdDnsServerAdd.Size = new System.Drawing.Size(56, 20);
            this.cmdDnsServerAdd.TabIndex = 6;
            this.cmdDnsServerAdd.Text = "Add";
            this.cmdDnsServerAdd.Click += new System.EventHandler(this.cmdDnsServerAdd_Click);
            // 
            // cmdDnsServerEdit
            // 
            this.cmdDnsServerEdit.Location = new System.Drawing.Point(246, 41);
            this.cmdDnsServerEdit.Name = "cmdDnsServerEdit";
            this.cmdDnsServerEdit.Size = new System.Drawing.Size(56, 22);
            this.cmdDnsServerEdit.TabIndex = 7;
            this.cmdDnsServerEdit.Text = "Edit";
            this.cmdDnsServerEdit.Click += new System.EventHandler(this.cmdDnsServerEdit_Click);
            // 
            // cmdDnsServerRemove
            // 
            this.cmdDnsServerRemove.Location = new System.Drawing.Point(246, 65);
            this.cmdDnsServerRemove.Name = "cmdDnsServerRemove";
            this.cmdDnsServerRemove.Size = new System.Drawing.Size(56, 23);
            this.cmdDnsServerRemove.TabIndex = 8;
            this.cmdDnsServerRemove.Text = "Remove";
            this.cmdDnsServerRemove.Click += new System.EventHandler(this.cmdDnsServerRemove_Click);
            // 
            // smtpSettings
            // 
            this.smtpSettings.Controls.Add(this.lbMs1);
            this.smtpSettings.Controls.Add(this.lblSmtpTimeout);
            this.smtpSettings.Controls.Add(this.txtSmtpTimeout);
            this.smtpSettings.Controls.Add(this.lblSmtpPort);
            this.smtpSettings.Controls.Add(this.txtSmtpPort);
            this.smtpSettings.Controls.Add(this.lblFromDomain);
            this.smtpSettings.Controls.Add(this.txtFromDomain);
            this.smtpSettings.Controls.Add(this.lblMailFrom);
            this.smtpSettings.Controls.Add(this.txtMailFrom);
            this.smtpSettings.Location = new System.Drawing.Point(10, 6);
            this.smtpSettings.Name = "smtpSettings";
            this.smtpSettings.Size = new System.Drawing.Size(269, 131);
            this.smtpSettings.TabIndex = 54;
            this.smtpSettings.TabStop = false;
            this.smtpSettings.Text = "Smtp Settings";
            // 
            // lbMs1
            // 
            this.lbMs1.Location = new System.Drawing.Point(158, 99);
            this.lbMs1.Name = "lbMs1";
            this.lbMs1.Size = new System.Drawing.Size(20, 13);
            this.lbMs1.TabIndex = 51;
            this.lbMs1.Text = "ms";
            // 
            // lblSmtpTimeout
            // 
            this.lblSmtpTimeout.Location = new System.Drawing.Point(10, 99);
            this.lblSmtpTimeout.Name = "lblSmtpTimeout";
            this.lblSmtpTimeout.Size = new System.Drawing.Size(48, 13);
            this.lblSmtpTimeout.TabIndex = 11;
            this.lblSmtpTimeout.Text = "Timeout:";
            // 
            // txtSmtpTimeout
            // 
            this.txtSmtpTimeout.Location = new System.Drawing.Point(88, 96);
            this.txtSmtpTimeout.Name = "txtSmtpTimeout";
            this.txtSmtpTimeout.Size = new System.Drawing.Size(66, 21);
            this.txtSmtpTimeout.TabIndex = 4;
            // 
            // lblSmtpPort
            // 
            this.lblSmtpPort.Location = new System.Drawing.Point(10, 73);
            this.lblSmtpPort.Name = "lblSmtpPort";
            this.lblSmtpPort.Size = new System.Drawing.Size(56, 13);
            this.lblSmtpPort.TabIndex = 9;
            this.lblSmtpPort.Text = "Smtp Port:";
            // 
            // txtSmtpPort
            // 
            this.txtSmtpPort.Location = new System.Drawing.Point(88, 70);
            this.txtSmtpPort.Name = "txtSmtpPort";
            this.txtSmtpPort.Size = new System.Drawing.Size(66, 21);
            this.txtSmtpPort.TabIndex = 3;
            this.txtSmtpPort.Text = "25";
            // 
            // lblFromDomain
            // 
            this.lblFromDomain.Location = new System.Drawing.Point(10, 48);
            this.lblFromDomain.Name = "lblFromDomain";
            this.lblFromDomain.Size = new System.Drawing.Size(72, 13);
            this.lblFromDomain.TabIndex = 7;
            this.lblFromDomain.Text = "From Domain:";
            // 
            // txtFromDomain
            // 
            this.txtFromDomain.Location = new System.Drawing.Point(88, 45);
            this.txtFromDomain.Name = "txtFromDomain";
            this.txtFromDomain.Size = new System.Drawing.Size(169, 21);
            this.txtFromDomain.TabIndex = 2;
            // 
            // dnsSettings
            // 
            this.dnsSettings.Controls.Add(this.lblDnsTimeout);
            this.dnsSettings.Controls.Add(this.lbMs);
            this.dnsSettings.Controls.Add(this.txtDnsTimeout);
            this.dnsSettings.Controls.Add(this.chkRandomDns);
            this.dnsSettings.Controls.Add(this.lbxDnsServers);
            this.dnsSettings.Controls.Add(this.cmdDnsServerAdd);
            this.dnsSettings.Controls.Add(this.lblDnsServer);
            this.dnsSettings.Controls.Add(this.cmdDnsServerEdit);
            this.dnsSettings.Controls.Add(this.cmdDnsServerRemove);
            this.dnsSettings.Location = new System.Drawing.Point(285, 6);
            this.dnsSettings.Name = "dnsSettings";
            this.dnsSettings.Size = new System.Drawing.Size(313, 131);
            this.dnsSettings.TabIndex = 55;
            this.dnsSettings.TabStop = false;
            this.dnsSettings.Text = "Dns Settings";
            // 
            // lblDnsTimeout
            // 
            this.lblDnsTimeout.Location = new System.Drawing.Point(8, 101);
            this.lblDnsTimeout.Name = "lblDnsTimeout";
            this.lblDnsTimeout.Size = new System.Drawing.Size(70, 13);
            this.lblDnsTimeout.TabIndex = 56;
            this.lblDnsTimeout.Text = "Dns Timeout:";
            // 
            // lbMs
            // 
            this.lbMs.Location = new System.Drawing.Point(151, 101);
            this.lbMs.Name = "lbMs";
            this.lbMs.Size = new System.Drawing.Size(20, 13);
            this.lbMs.TabIndex = 50;
            this.lbMs.Text = "ms";
            // 
            // txtDnsTimeout
            // 
            this.txtDnsTimeout.Location = new System.Drawing.Point(78, 98);
            this.txtDnsTimeout.Name = "txtDnsTimeout";
            this.txtDnsTimeout.Size = new System.Drawing.Size(67, 21);
            this.txtDnsTimeout.TabIndex = 9;
            // 
            // chkRandomDns
            // 
            this.chkRandomDns.Location = new System.Drawing.Point(197, 95);
            this.chkRandomDns.Name = "chkRandomDns";
            this.chkRandomDns.Size = new System.Drawing.Size(110, 26);
            this.chkRandomDns.TabIndex = 10;
            this.chkRandomDns.Text = "Use Random Dns";
            // 
            // blackwhiteLists
            // 
            this.blackwhiteLists.Controls.Add(this.lblWhiteList);
            this.blackwhiteLists.Controls.Add(this.txtWhiteList);
            this.blackwhiteLists.Controls.Add(this.cmdWhiteListBrowse);
            this.blackwhiteLists.Controls.Add(this.lblBlackList);
            this.blackwhiteLists.Controls.Add(this.txtBlackList);
            this.blackwhiteLists.Controls.Add(this.cmdBlackListBrowse);
            this.blackwhiteLists.Location = new System.Drawing.Point(10, 143);
            this.blackwhiteLists.Name = "blackwhiteLists";
            this.blackwhiteLists.Size = new System.Drawing.Size(588, 77);
            this.blackwhiteLists.TabIndex = 56;
            this.blackwhiteLists.TabStop = false;
            this.blackwhiteLists.Text = "Black List and White List";
            // 
            // general
            // 
            this.general.Controls.Add(this.chkDeepCheck);
            this.general.Controls.Add(this.lbMs2);
            this.general.Controls.Add(this.lblCacheTimeout);
            this.general.Controls.Add(this.txtCacheTimeout);
            this.general.Controls.Add(this.chkCacheMXRecords);
            this.general.Controls.Add(this.txtSyntaxPattern);
            this.general.Controls.Add(this.lblEmailSyntaxPattern);
            this.general.Controls.Add(this.lblValidationLevel);
            this.general.Controls.Add(this.cboValidationLevel);
            this.general.Location = new System.Drawing.Point(10, 226);
            this.general.Name = "general";
            this.general.Size = new System.Drawing.Size(588, 96);
            this.general.TabIndex = 57;
            this.general.TabStop = false;
            this.general.Text = "General";
            // 
            // chkDeepCheck
            // 
            this.chkDeepCheck.Location = new System.Drawing.Point(88, 66);
            this.chkDeepCheck.Name = "chkDeepCheck";
            this.chkDeepCheck.Size = new System.Drawing.Size(143, 26);
            this.chkDeepCheck.TabIndex = 19;
            this.chkDeepCheck.Text = "Deeply Check Mailboxes";
            // 
            // lbMs2
            // 
            this.lbMs2.Location = new System.Drawing.Point(426, 49);
            this.lbMs2.Name = "lbMs2";
            this.lbMs2.Size = new System.Drawing.Size(29, 13);
            this.lbMs2.TabIndex = 57;
            this.lbMs2.Text = "secs";
            // 
            // lblCacheTimeout
            // 
            this.lblCacheTimeout.Location = new System.Drawing.Point(281, 46);
            this.lblCacheTimeout.Name = "lblCacheTimeout";
            this.lblCacheTimeout.Size = new System.Drawing.Size(48, 26);
            this.lblCacheTimeout.TabIndex = 59;
            this.lblCacheTimeout.Text = "Cache \r\nTimeout:";
            // 
            // txtCacheTimeout
            // 
            this.txtCacheTimeout.Location = new System.Drawing.Point(353, 47);
            this.txtCacheTimeout.Name = "txtCacheTimeout";
            this.txtCacheTimeout.Size = new System.Drawing.Size(67, 21);
            this.txtCacheTimeout.TabIndex = 18;
            // 
            // chkCacheMXRecords
            // 
            this.chkCacheMXRecords.Location = new System.Drawing.Point(88, 43);
            this.chkCacheMXRecords.Name = "chkCacheMXRecords";
            this.chkCacheMXRecords.Size = new System.Drawing.Size(173, 26);
            this.chkCacheMXRecords.TabIndex = 17;
            this.chkCacheMXRecords.Text = "Cache Mail Exchange Records";
            // 
            // txtSyntaxPattern
            // 
            this.txtSyntaxPattern.Location = new System.Drawing.Point(353, 16);
            this.txtSyntaxPattern.Name = "txtSyntaxPattern";
            this.txtSyntaxPattern.Size = new System.Drawing.Size(224, 21);
            this.txtSyntaxPattern.TabIndex = 16;
            // 
            // lblEmailSyntaxPattern
            // 
            this.lblEmailSyntaxPattern.Location = new System.Drawing.Point(281, 14);
            this.lblEmailSyntaxPattern.Name = "lblEmailSyntaxPattern";
            this.lblEmailSyntaxPattern.Size = new System.Drawing.Size(67, 26);
            this.lblEmailSyntaxPattern.TabIndex = 57;
            this.lblEmailSyntaxPattern.Text = "Email Syntax\r\nPattern:";
            // 
            // SettingsDialog
            // 
            this.AcceptButton = this.cmdOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.cmdCancel;
            this.ClientSize = new System.Drawing.Size(607, 362);
            this.Controls.Add(this.general);
            this.Controls.Add(this.blackwhiteLists);
            this.Controls.Add(this.dnsSettings);
            this.Controls.Add(this.smtpSettings);
            this.Controls.Add(this.cmdCancel);
            this.Controls.Add(this.cmdOK);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "SettingsDialog";
            this.ShowInTaskbar = false;
            this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
            this.Text = "Validator Settings";
            this.Load += new System.EventHandler(this.SettingsForm_Load);
            this.smtpSettings.ResumeLayout(false);
            this.smtpSettings.PerformLayout();
            this.dnsSettings.ResumeLayout(false);
            this.dnsSettings.PerformLayout();
            this.blackwhiteLists.ResumeLayout(false);
            this.blackwhiteLists.PerformLayout();
            this.general.ResumeLayout(false);
            this.general.PerformLayout();
            this.ResumeLayout(false);

        }
        #endregion

        /// <summary>
        /// Handles the OK button's Click event.
        /// </summary>
        /// <param name="sender">The button object.</param>
        /// <param name="e">The event arguments.</param>
        private void cmdOK_Click(object sender, System.EventArgs e)
        {
            string msg;

            // Set Smtp info.
            _validator.SmtpFromEmail = txtMailFrom.Text;
            _validator.SmtpHeloDomain = txtFromDomain.Text;
            try
            {
                _validator.SmtpPort = int.Parse(txtSmtpPort.Text);
                if (_validator.SmtpPort < 0 || _validator.SmtpPort > 65535)
                {
                    msg = "Invalid Smtp Port, it must be between 0 to 65535";
                    txtSmtpPort.Focus();
                    goto HasError;
                }
            }
            catch (FormatException exc)
            {
                msg = "Invalid Smtp Port: " + exc.Message;
                txtSmtpPort.Focus();
                goto HasError;
            }
            try
            {
                _validator.SmtpTimeout = int.Parse(txtSmtpTimeout.Text);
                if (_validator.SmtpTimeout < 0 || _validator.SmtpTimeout > 3000000)
                {
                    msg = "Invalid Smtp Timeout, it must be between 0 to 3000000";
                    txtSmtpTimeout.Focus();
                    goto HasError;
                }
            }
            catch (FormatException exc)
            {
                msg = "Invalid Smtp Timeout: " + exc.Message;
                txtSmtpTimeout.Focus();
                goto HasError;
            }

            // Set Dns info
            try
            {
                _validator.DnsTimeout = int.Parse(txtDnsTimeout.Text);
                if (_validator.DnsTimeout < 0 || _validator.DnsTimeout > 3000000)
                {
                    msg = "Invalid Dns Timeout, it must be between 0 to 3000000";
                    txtDnsTimeout.Focus();
                    goto HasError;
                }
            }
            catch (FormatException exc)
            {
                msg = "Invalid Dns Timeout: " + exc.Message;
                txtDnsTimeout.Focus();
                goto HasError;
            }

            _validator.UseRandomDnsServer = chkRandomDns.Checked;
            _validator.DnsServers.Clear();
            foreach (string str in lbxDnsServers.Items)
                _validator.DnsServers.Add(str);

            switch (cboValidationLevel.SelectedIndex)
            {
                case 0:
                    _validator.ValidationLevel = ValidationLevel.Syntax;
                    break;

                case 1:
                    _validator.ValidationLevel = ValidationLevel.Lists;
                    break;

                case 2:
                    _validator.ValidationLevel = ValidationLevel.MailExchangeRecords;
                    break;

                case 3:
                    _validator.ValidationLevel = ValidationLevel.SmtpConnection;
                    break;

                case 4:
                    _validator.ValidationLevel = ValidationLevel.Mailbox;
                    break;
            }

            _validator.UseMailExchangeRecordCache = chkCacheMXRecords.Checked;
            _validator.DeepMailboxCheck = chkDeepCheck.Checked;
            _validator.EmailSyntaxPattern = txtSyntaxPattern.Text;

            try
            {
                _validator.MailExchangeRecordCacheTimeout = int.Parse(txtCacheTimeout.Text);
                if (_validator.MailExchangeRecordCacheTimeout < 0 || _validator.MailExchangeRecordCacheTimeout > 3000000)
                {
                    msg = "Invalid MailExchangeRecordCacheTimeout, it must be between 0 to 3000000";
                    txtCacheTimeout.Focus();
                    goto HasError;
                }
            }
            catch (FormatException exc)
            {
                msg = "Invalid MailExchangeRecordCacheTimeout: " + exc.Message;
                txtCacheTimeout.Focus();
                goto HasError;
            }

            DialogResult = DialogResult.OK;
            return;

        HasError:
            MessageBox.Show(msg, "Error", MessageBoxButtons.OK, MessageBoxIcon.Stop);
            return;
        }

        private void TextBox_Enter(object sender, System.EventArgs e)
        {
            System.Windows.Forms.TextBox box = (System.Windows.Forms.TextBox)sender;
            box.SelectionStart = 0;
            box.SelectionLength = box.Text.Length;
        }

        private void SettingsForm_Load(object sender, System.EventArgs e)
        {
        }

        private void cmdDnsServerAdd_Click(object sender, System.EventArgs e)
        {
            IPAddressForm dlg = new IPAddressForm();
            if (dlg.ShowDialog() != DialogResult.OK)
                return;

            foreach (string s in lbxDnsServers.Items)
                if (s == dlg.Address)
                    return;

            lbxDnsServers.Items.Add(dlg.Address);
        }

        private void cmdDnsServerRemove_Click(object sender, System.EventArgs e)
        {
            int index = lbxDnsServers.SelectedIndex;
            if (index < 0)
                return;

            lbxDnsServers.Items.RemoveAt(index);

            if (lbxDnsServers.Items.Count == 0)
                return;

            if (index == lbxDnsServers.Items.Count)
                index--;

            lbxDnsServers.SelectedIndex = index;
        }

        private void lbxDnsServers_SelectedIndexChanged(object sender, System.EventArgs e)
        {
            int index = lbxDnsServers.SelectedIndex;
            if (index < 0)
                cmdDnsServerRemove.Enabled = cmdDnsServerEdit.Enabled = false;
            else
                cmdDnsServerRemove.Enabled = cmdDnsServerEdit.Enabled = true;
        }

        private void cmdDnsServerEdit_Click(object sender, System.EventArgs e)
        {
            object objItem = lbxDnsServers.SelectedItem;
            int index = lbxDnsServers.SelectedIndex;
            if (index == -1)
                return;

            IPAddressForm dlg = new IPAddressForm((string)objItem);
            if (dlg.ShowDialog() != DialogResult.OK)
                return;

            lbxDnsServers.Items[index] = dlg.Address;
        }

        private void cmdWhiteListBrowse_Click(object sender, System.EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.FileName = txtWhiteList.Text;
            dlg.Filter = "List File (*.txt)|*.txt|All files (*.*)|*.*";
            dlg.FilterIndex = 1;
            dlg.Title = "Select White List File";
            if (dlg.ShowDialog() != DialogResult.OK)
                return;

            txtWhiteList.Text = dlg.FileName;
        }

        private void cmdBlackListBrowse_Click(object sender, System.EventArgs e)
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.FileName = txtBlackList.Text;
            dlg.Filter = "List File (*.txt)|*.txt|All files (*.*)|*.*";
            dlg.FilterIndex = 1;
            dlg.Title = "Select Black List File";
            if (dlg.ShowDialog() != DialogResult.OK)
                return;

            txtBlackList.Text = dlg.FileName;
        }

        private void lbxDnsServers_DoubleClick(object sender, System.EventArgs e)
        {
            cmdDnsServerEdit_Click(sender, e);
        }
    }
}