﻿<%@ Page Language="vb" AutoEventWireup="true" CodeBehind="Default.aspx.vb" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
	<title>UltimateEmailValidator Web Demonstration</title>
	<link rel="Stylesheet" href="Css/Styles.css" />
</head>
<body>
	<form id="form1" runat="server">
		<div class="templatecontent">
			<div class="header">
				<a href="http://www.componentpro.com">
					<img src="Css/Logo.gif" /></a>
			</div>
			This web application will illustrate how to use UltimateEmailValidator in a Web
			Application.<br />
			<br />
			<b>How to use: All fields in bold are required.</b><ul>
				<li><b>Email Address</b>: The email address that you wish to validate.</li>
				<li><b>Validation Level</b>: Desired level of validation you wish to use.</li>
				<li><b>From Domain</b>: Originating domain passed to the SMTP server as the HELO parameter.</li>
				<li><b>SMTP From Mail</b>: The from email address to use when attempting a send.</li>
				<li><b>SMTP Port</b>: The mail port to use when attempting a send. Default value is
					25.</li>
				<li><b>DNS Server</b>: Originating domain passed to the SMTP server as the HELO parameter.</li>
			</ul>
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="3">
					<tr>
						<td style="white-space: nowrap">
							<b>Email Address:</b></td>
						<td width="100%">
							<asp:TextBox ID="txtEmail" runat="server" CssClass="textbox"></asp:TextBox></td>
					</tr>
					<tr>
						<td style="white-space: nowrap">
						</td>
						<td>
							<asp:RegularExpressionValidator ID="revEmailIsInvalid" runat="server" CssClass="error-1"
								ErrorMessage="Email is invalid" ControlToValidate="txtEmail" ValidationExpression="\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"
								Display="Dynamic"></asp:RegularExpressionValidator>
							<asp:RequiredFieldValidator ID="rfvEmailIsRequired" runat="server" CssClass="error-1"
								ErrorMessage="Email is required" ControlToValidate="txtEmail" Display="Dynamic"></asp:RequiredFieldValidator></td>
					</tr>
					<tr>
						<td style="white-space: nowrap">
							Validation Level:</td>
						<td>
							<asp:DropDownList ID="ddlValidationLevel" runat="server" Width="162px" CssClass="dropdown">
								<asp:ListItem Value="2">Syntax</asp:ListItem>
								<asp:ListItem Value="3">List</asp:ListItem>
								<asp:ListItem Value="4">Mail Exchange Records</asp:ListItem>
								<asp:ListItem Value="5">Smtp Connection</asp:ListItem>
								<asp:ListItem Selected="True" Value="6">Mailbox</asp:ListItem>
							</asp:DropDownList></td>
					</tr>
					<tr>
						<td style="white-space: nowrap">
							From Domain:</td>
						<td>
							<asp:TextBox ID="txtFromDomain" runat="server" CssClass="textbox"></asp:TextBox></td>
					</tr>
					<tr>
						<td style="white-space: nowrap">
							SMTP From Mail:</td>
						<td>
							<asp:TextBox ID="txtSmtpMail" runat="server" CssClass="textbox"></asp:TextBox></td>
					</tr>
					<tr>
						<td style="white-space: nowrap">
							SMTP Port:</td>
						<td>
							<asp:TextBox ID="txtSmtpPort" runat="server" CssClass="textbox"></asp:TextBox></td>
					</tr>
					<tr>
						<td style="white-space: nowrap">
							DNS Server:</td>
						<td>
							<asp:TextBox ID="txtDnsServer" runat="server" CssClass="textbox"></asp:TextBox></td>
					</tr>
					<tr>
						<td colspan="2">
							<asp:Label ID="lblResult" runat="server" CssClass="bodytext"></asp:Label></td>
					</tr>
					<tr>
						<td colspan="2">
							<asp:Button CssClass="okbutton" ID="btnValidate" runat="server" Text="Validate" OnClick="btnValidate_Click" /></td>
					</tr>
				</table>
			</div>
		</div>
	</form>
</body>
</html>