﻿Imports ComponentPro.Net.Mail

Namespace ScanPop3Sample
	Partial Public Class Signature
		Inherits Form
		Private Shared _uniqueCode As Integer = 1000 ' Uniquely incremental bounce signature identifier.
		Private ReadOnly _filter As BounceInspector ' The BounceInspector object.
		Private _modifyMode As Boolean ' Modify?
		Private _categoryCode, _typeCode As Integer ' Bounce Category and Bounce Type infomation.
		Private _pattern As String ' The Regex pattern for this signature.
		Private _delete As Boolean ' Indicates whether hard bounce will be deleted.
		Private _part As BounceSignaturePart ' Indicates which part of the processing message will be analyzed.

		''' <summary>
		''' Initializes a new instance of the class.
		''' </summary>
		''' <param name="filter">The BounceInspector object.</param>
		''' <param name="modifyMode">A boolean flags indicating the modifying mode.</param>
		Public Sub New(ByVal filter As BounceInspector, ByVal modifyMode As Boolean)
			InitializeComponent()

			_filter = filter

			' Load up the bounce categories and fill them into the Category combo box.
			For Each bc As BounceCategory In _filter.BounceCategories.Values
				cbxCategory.Items.Add(bc.Name)
				If bc.Code = _categoryCode Then
					cbxCategory.Text = bc.Name
				End If
			Next bc

			' Load up the bounce types and fill them into the Type combo box.
			For Each bt As BounceType In _filter.BounceTypes.Values
				cbxType.Items.Add(bt.Name)
				If bt.Code = _typeCode Then
					cbxType.Text = bt.Name
				End If
			Next bt

			_modifyMode = modifyMode
		End Sub

		''' <summary>
		''' Handles the Form Load event.
		''' </summary>
		''' <param name="e">The event arguments.</param>
		Protected Overrides Sub OnLoad(ByVal e As EventArgs)
			MyBase.OnLoad(e)

			' Modify signature?
			If _modifyMode Then
				' Change the title
				Me.Text = "Modify custom signature"
				' Set text.
				txtPattern.Text = _pattern

				chkContent.Checked = (_part And BounceSignaturePart.Body) = BounceSignaturePart.Body
				chkSubject.Checked = (_part And BounceSignaturePart.Subject) = BounceSignaturePart.Subject
				chkBodyHtml.Checked = (_part And BounceSignaturePart.BodyHtml) = BounceSignaturePart.BodyHtml
				chkHeaders.Checked = (_part And BounceSignaturePart.Headers) = BounceSignaturePart.Headers
				chkAttachmentsName.Checked = (_part And BounceSignaturePart.AttachmentName) = BounceSignaturePart.AttachmentName
				chkAttachmentsContent.Checked = (_part And BounceSignaturePart.AttachmentContent) = BounceSignaturePart.AttachmentContent

				chkDelete.Checked = _delete
				chkAnalyzeFirst.Enabled = False
				cbxCategory.Text = _filter.BounceCategories(_categoryCode).Name
				cbxType.Text = _filter.BounceTypes(_typeCode).Name
			Else
				Me.Text = "Add a new custom signature"
			End If
		End Sub

		Public Property ModifyMode() As Boolean
			Get
				Return _modifyMode
			End Get
			Set(ByVal value As Boolean)
				_modifyMode = value
			End Set
		End Property

		Public Property CategoryCode() As Integer
			Get
				Return _categoryCode
			End Get
			Set(ByVal value As Integer)
				_categoryCode = value
			End Set
		End Property

		Public Property TypeCode() As Integer
			Get
				Return _typeCode
			End Get
			Set(ByVal value As Integer)
				_typeCode = value
			End Set
		End Property

		Public Property Pattern() As String
			Get
				Return _pattern
			End Get
			Set(ByVal value As String)
				_pattern = value
			End Set
		End Property

		Public Property Delete() As Boolean
			Get
				Return _delete
			End Get
			Set(ByVal value As Boolean)
				_delete = value
			End Set
		End Property

		Public Property Part() As BounceSignaturePart
			Get
				Return _part
			End Get
			Set(ByVal value As BounceSignaturePart)
				_part = value
			End Set
		End Property

		Public ReadOnly Property CheckFirst() As Boolean
			Get
				Return chkAnalyzeFirst.Checked
			End Get
		End Property

		''' <summary>
		''' Handles the OK button's Click event.
		''' </summary>
		''' <param name="sender">The button object.</param>
		''' <param name="e">The event arguments.</param>
		Private Sub btnOK_Click(ByVal sender As Object, ByVal e As EventArgs) Handles btnOK.Click
			DialogResult = System.Windows.Forms.DialogResult.None

			' Validate the form controls.
			If txtPattern.Text.Length = 0 Then
				MessageBox.Show("Please enter signature regex pattern", "BounceInspector", MessageBoxButtons.OK)
				Return
			End If

			If cbxCategory.Text.Length = 0 Then
				MessageBox.Show("Please choose a category", "BounceInspector", MessageBoxButtons.OK)
				Return
			End If

			If cbxType.Text.Length = 0 Then
				MessageBox.Show("Please choose a type", "BounceInspector", MessageBoxButtons.OK)
				Return
			End If

			Dim found As Boolean = False

			' Check to see whether the category already exists.
			For Each bc As BounceCategory In _filter.BounceCategories.Values
				If String.Compare(bc.Name, cbxCategory.Text, True) = 0 Then
					found = True
					_categoryCode = bc.Code
					Exit For
				End If
			Next bc
			If Not found Then
				' If the category does not exist, then add it to the Bounce Category list.
				_uniqueCode += 1
				_filter.AddBounceCategory(_uniqueCode, cbxCategory.Text)
				_categoryCode = _uniqueCode
			End If

			found = False
			' Check to see whether the type already exists.
			For Each bt As BounceType In _filter.BounceTypes.Values
				If String.Compare(bt.Name, cbxType.Text, True) = 0 Then
					found = True
					_typeCode = bt.Code
					Exit For
				End If
			Next bt
			If Not found Then
				' If the category does not exist, then add it to the Bounce Type list.
				_uniqueCode += 1
				_filter.AddBounceType(_uniqueCode, cbxType.Text)
				_typeCode = _uniqueCode
			End If

			_part = BounceSignaturePart.None
			If chkContent.Checked Then ' If user wants to analyze body text.
				_part = _part Or BounceSignaturePart.Body
			End If
			If chkSubject.Checked Then ' If user wants to analyze subject.
				_part = _part Or BounceSignaturePart.Subject
			End If
			If chkBodyHtml.Checked Then ' If user wants to analyze body html.
				_part = _part Or BounceSignaturePart.BodyHtml
			End If
			If chkHeaders.Checked Then ' If user wants to analyze message headers.
				_part = _part Or BounceSignaturePart.Headers
			End If
			If chkAttachmentsName.Checked Then ' If user wants to analyze attachments' name.
				_part = _part Or BounceSignaturePart.AttachmentName
			End If
			If chkAttachmentsContent.Checked Then ' If user wants to analyze attachments' content.
				_part = _part Or BounceSignaturePart.AttachmentContent
			End If

			If _part = BounceSignaturePart.None Then ' No part selected
				MessageBox.Show("Please choose at least one part (body text, html, subject,...)", "BounceInspector", MessageBoxButtons.OK)
				Return
			End If

			_delete = chkDelete.Checked

			_pattern = txtPattern.Text

			Me.DialogResult = System.Windows.Forms.DialogResult.OK
		End Sub
	End Class
End Namespace