using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ComponentPro.Net.Mail;

namespace ScanMessagesSample
{
    public partial class Errors : Form
    {
        public Errors()
        {
            InitializeComponent();
        }

        string GetFileName(string fileName)
        {
            if (!string.IsNullOrEmpty(fileName))
                return System.IO.Path.GetFileName(fileName) + " - ";
            else
                return fileName;
        }

        public void SetErrors(BounceResultCollection col)
        {
            listView.Items.Clear();

            int count = 0;
            foreach (BounceResult r in col)
            {
                if (r.Error != null)
                {
                    listView.Items.Add(GetFileName(r.FilePath) + r.Error.Message);

                    count++;
                    if (count > 100)
                    {
                        listView.Items.Add("Too many errors...");
                        break;
                    }
                }
            }
        }
    }
}