using System;
using System.Windows.Forms;
using ComponentPro.Net;

namespace ScanImapSample
{
    public partial class Settings : Form
    {
        public Settings()
        {
            InitializeComponent();
            LoadConfigInternal();
        }

        #region Configuration

        private void SaveConfig()
        {
            // Save settings.
            Util.SaveProperty("ProxyServer", txtProxyHost.Text);
            Util.SaveProperty("ProxyPort", txtProxyPort.Text);
            Util.SaveProperty("ProxyUser", txtProxyUser.Text);
            Util.SaveProperty("ProxyPassword", txtProxyPassword.Text);
            Util.SaveProperty("ProxyDomain", txtProxyDomain.Text);
            Util.SaveProperty("ProxyType", cbxProxyType.SelectedIndex);
            Util.SaveProperty("ProxyMethod", cbxProxyMethod.SelectedIndex);
            Util.SaveProperty("Timeout", txtTimeout.Text);
        }

        public static ScanSettings LoadConfig()
        {
            // Load settings.
            ScanSettings s = new ScanSettings();
            s.ProxyServer = (string)Util.GetProperty("ProxyServer", string.Empty);
            s.ProxyPort = Util.GetIntProperty("ProxyPort", 1080);
            s.ProxyUser = (string)Util.GetProperty("ProxyUser", string.Empty);
            s.ProxyPassword = (string)Util.GetProperty("ProxyPassword", string.Empty);
            s.ProxyDomain = (string)Util.GetProperty("ProxyDomain", string.Empty);
            s.ProxyType = (ProxyType)Util.GetIntProperty("ProxyType", 0);
            s.ProxyMethod = (ProxyHttpConnectAuthMethod)Util.GetIntProperty("ProxyMethod", 0);
            s.Timeout = Util.GetIntProperty("Timeout", 30);

            return s;
        }

        private void LoadConfigInternal()
        {
            ScanSettings s = LoadConfig();
            txtProxyHost.Text = s.ProxyServer;
            txtProxyPort.Text = s.ProxyPort.ToString();
            txtProxyUser.Text = s.ProxyUser;
            txtProxyPassword.Text = s.ProxyPassword;
            txtProxyDomain.Text = s.ProxyDomain;
            cbxProxyType.SelectedIndex = (int)s.ProxyType;
            cbxProxyMethod.SelectedIndex = (int)s.ProxyMethod;
            txtTimeout.Text = s.Timeout.ToString();
        }

        #endregion

        private void btnOK_Click(object sender, EventArgs e)
        {
            int proxyport;
            try
            {
                proxyport = int.Parse(txtProxyPort.Text);
            }
            catch (Exception exc)
            {
                Util.ShowError(exc, "Invalid proxy port");
                return;
            }
            if (proxyport < 0 || proxyport > 65535)
            {
                MessageBox.Show("Invalid port number", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            int timeout;
            try
            {
                timeout = int.Parse(txtTimeout.Text);
            }
            catch (Exception exc)
            {
                Util.ShowError(exc, "Invalid timeout");
                return;
            }
            if (timeout < 1)
            {
                MessageBox.Show("Invalid timeout, it must be greater than or equal to 1", "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            SaveConfig();
            this.DialogResult = DialogResult.OK;
        }

        /// <summary>
        /// Handles the combo box proxy type's SelectedIndexChanged event.
        /// </summary>
        /// <param name="sender">The combo box.</param>
        /// <param name="e">The event arguments.</param>
        private void cbxProxy_SelectedIndexChanged(object sender, EventArgs e)
        {
            bool enable = cbxProxyType.SelectedIndex > 0;

            cbxProxyMethod.Enabled = cbxProxyType.SelectedIndex == (int)ProxyType.HttpConnect; // Authentication method is available for HTTP Connect only.
            txtProxyDomain.Enabled = cbxProxyMethod.Enabled && cbxProxyMethod.SelectedIndex == (int)ProxyHttpConnectAuthMethod.Ntlm; // Domain is available for NTLM authentication method only.
            txtProxyUser.Enabled = enable/* && cbxProxyType.SelectedIndex != (int)ProxyType.SendToProxy*/; // User name and password are ignored with SendToProxy proxy type.
            txtProxyPassword.Enabled = enable/* && cbxProxyType.SelectedIndex != (int)ProxyType.SendToProxy*/;
            txtProxyHost.Enabled = enable; // Proxy host and port are not available in NoProxy type.
            txtProxyPort.Enabled = enable;
        }
    }
}