Imports System.Text
Imports System.Web.UI.WebControls
Imports ComponentPro.Net
Imports ComponentPro.Net.Mail

Partial Public Class _Default
	Inherits System.Web.UI.Page
	Private Sub PopulateEnum()
		Dim arr() As ImapAuthenticationMethod = CType(System.Enum.GetValues(GetType(ImapAuthenticationMethod)), ImapAuthenticationMethod())

		For i As Integer = 0 To arr.Length - 1
			ddlAuthentication.Items.Add(New ListItem(arr(i).ToString(), CInt(Fix(arr(i))).ToString()))
		Next i

		Dim index As Integer
		If Integer.TryParse(Request.Form("ddlAuthentication"), index) Then
			ddlAuthentication.SelectedIndex = index
		End If
	End Sub

	Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs)
		PopulateEnum()
	End Sub
	Protected Sub btnProcess_Click(ByVal sender As Object, ByVal e As EventArgs)
		' Create a new instance of the ImapClient class for retrieving mail messages.
		Dim client As New Imap()

		Try
			' Setup the directory for storing messages.
			Dim mailsPath As String = AppDomain.CurrentDomain.BaseDirectory & "Mails"
			If Not System.IO.Directory.Exists(mailsPath) Then
				System.IO.Directory.CreateDirectory(mailsPath)
			End If

			' Initialize the message string.
			Dim sb As New StringBuilder()
			' Parse the IMAP port.
			Dim port As Integer = Integer.Parse(txtPort.Text)

			' Connect to the server.
			client.Connect(txtServer.Text, port, CType(ddlSecurityMode.SelectedIndex, SecurityMode))

			' Login to the server.
			Dim ia As ImapAuthenticationMethod = CType(Integer.Parse(ddlAuthentication.SelectedValue), ImapAuthenticationMethod)
			' Login to the IMAP server.
			client.Authenticate(txtUser.Text, txtPassword.Text, ia)

			' Selecting folder is needed.
			client.Select(txtFolder.Text)

			' Create a new instance of the BounceInspector class for detecting and filtering bounced messages.
			Dim filter As New BounceInspector()
			' Delete hard bounce file?
			filter.AllowDelete = chkDelete.Checked
			' Delete bard bounce in inbox as well?
			filter.AllowInboxDelete = chkDelete.Checked
			' The maximum number of message to be downloaded.
			filter.MaxMessages = Integer.Parse(txtMessages.Text)
			' Process all messages.
			Dim result As BounceResultCollection = filter.ProcessMessages(client, txtFolder.Text, mailsPath)

			' Display processed emails.
			For Each r As BounceResult In result
				' If this is a detected bounce.
				If r.Identified Then
					' Add to the result text.
					If r.Addresses.Length > 0 Then
						sb.AppendFormat("FileName: {0}<br>Subject: {1}<br>Address: {2}<br>Bounce Category: {3}<br>Bounce Type: {4}<br>Deleted: {5}<br>DSN Action: {6}<br>DSN Diagnostic Code: {7}<br><br>", System.IO.Path.GetFileName(r.FilePath), r.MailMessage.Subject,r.Addresses(0), r.BounceCategory.Name, r.BounceType.Name, r.FileDeleted, r.Dsn.Action, r.Dsn.DiagnosticCode)
					Else
						sb.AppendFormat("FileName: {0}<br>Subject: {1}<br>Address: {2}<br>Bounce Category: {3}<br>Bounce Type: {4}<br>Deleted: {5}<br>DSN Action: {6}<br>DSN Diagnostic Code: {7}<br><br>", System.IO.Path.GetFileName(r.FilePath), r.MailMessage.Subject,String.Empty, r.BounceCategory.Name, r.BounceType.Name, r.FileDeleted, r.Dsn.Action, r.Dsn.DiagnosticCode)
					End If
				End If
			Next r

			' Print out the result.
			sb.AppendFormat("{0} bounced message(s) found!", result.BounceCount)
			lblResult.Text = sb.ToString()
		Catch exc As Exception
			lblResult.Text = String.Format(Nothing, "Exception: {0}", exc.Message)
		Finally
			' Disconnect.
			client.Disconnect()
		End Try
	End Sub
End Class