﻿<%@ Page Language="C#" Async="true" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>UltimateBounceInspector C# Web Sample</title>
    <link rel="Stylesheet" href="Css/Styles.css" />
</head>
<body>
    <form id="myform" runat="server">
        <div class="templatecontent">
            <div class="header">
                <a href="http://www.componentpro.com">
                    <img src="Css/Logo.gif" /></a>
            </div>
            This example demonstrates how to use UltimateBounceInspector to download messages
            from an IMAP server and asynchronously process them in a Web Application using ComponentProBounceInspector.
            When the operation is completed, an e-mail message will be sent to notify the completion.<br />
            <br />
            <b>How to use:</b> All fields in <strong>bold</strong> are required.<ul>
                <li><b>Imap Server: </b>The server address. </li>
                <li><strong>Imap Port: </strong>The server port (default port is 143). </li>
                <li><strong>Security Mode: </strong>The IMAP connection security. </li>
                <li><strong>Imap User: </strong>The Imap User Name. </li>
                <li><strong>Password: </strong>The Password. </li>
                <li><strong>Authentication Method: </strong>The IMAP client authentication method.</li>
                <li><strong>Messages: </strong>The maximum number of messages to download and process.</li>
                <li><strong>Delete Hard Bounces: </strong>Indicates whether the hard bounced e-mails
                    will be deleted.</li>
                <li><b>Smtp Server: </b>The Smtp server address used to send notification. </li>
                <li><strong>Smtp Port: </strong>The Smtp server port (default port is 25). </li>
                <li><strong>Security Mode: </strong>The SMTP connection security. </li>
                <li><strong>Smtp User: </strong>The Smtp User Name. </li>
                <li><strong>Password: </strong>The Password. </li>
                <li><strong>Authentication Method</strong>: The SMTP client authentication method.</li>
                <li><strong>From Email: </strong>The sender of the notification message. </li>
                <li><strong>To Email: </strong>The recipient of the message. </li>
                <li>Click on the <strong>Process</strong> button to download and process messages.</li>
            </ul>
            <div class="content">
                <table border="0" cellspacing="0" cellpadding="3">
                    <tr>
                        <td colspan="2">
                            <h3 style="padding-top: 8px">
                                IMAP and BounceInspector Settings</h3>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Imap Server:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtServer" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfv" runat="server" CssClass="error-1" ErrorMessage="Imap server Address is required"
                                ControlToValidate="txtServer" Display="Dynamic"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Imap Port:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtPort" runat="server" CssClass="textbox" Width="50px">143</asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvPort" runat="server" CssClass="error-1" ErrorMessage="Imap port is required"
                                ControlToValidate="txtPort" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RangeValidator ID="rvPort" runat="server" CssClass="error-1" ControlToValidate="txtPort"
                                ErrorMessage="Imap Port is invalid" MaximumValue="65535" MinimumValue="1" Type="Integer"></asp:RangeValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Security Mode:</td>
                        <td width="100%">
                            <asp:DropDownList ID="ddlSecurityMode" runat="server" CssClass="dropdown" Width="200px">
                                <asp:ListItem>Unsecure</asp:ListItem>
                                <asp:ListItem>Implicit</asp:ListItem>
                                <asp:ListItem>Explicit</asp:ListItem>
                            </asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Imap User:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtUser" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td>
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvUser" runat="server" CssClass="error-1" ErrorMessage="Please enter user name"
                                ControlToValidate="txtUser" Display="Dynamic"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Password:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtPassword" runat="server" CssClass="textbox" Width="200px" TextMode="Password"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td>
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvPassword" runat="server" CssClass="error-1" ErrorMessage="Please enter password"
                                ControlToValidate="txtPassword" Display="Dynamic"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Authentication Method:</td>
                        <td width="100%">
                            <asp:DropDownList ID="ddlAuthentication" runat="server" CssClass="dropdown" Width="200px">
                            </asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Working Folder:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtFolder" runat="server" CssClass="textbox" Width="200px">Inbox</asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvFolder" runat="server" CssClass="error-1" ErrorMessage="The working folder is required"
                                ControlToValidate="txtFolder" Display="Dynamic"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Max Messages:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtMessages" runat="server" CssClass="textbox" Width="50px">100</asp:TextBox></td>
                    </tr>
                    <tr>
                        <td></td><td>The maxium number of messages to be downloaded and scanned (newest messages will be downloaded first)</td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvMessages" runat="server" CssClass="error-1" ErrorMessage="The maximum number of messages to download is required"
                                ControlToValidate="txtMessages" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RangeValidator ID="rvMessages" runat="server" ControlToValidate="txtMessages"
                                CssClass="error-1" ErrorMessage="The maximum number of messages to download is invalid. The maximum is 1000 in this example."
                                MaximumValue="1000" MinimumValue="1" Type="Integer"></asp:RangeValidator></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Delete Hard Bounces:</td>
                        <td width="100%">
                            <asp:CheckBox ID="chkDelete" runat="server" CssClass="checkbox"></asp:CheckBox></td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <h3 style="padding-top: 8px">
                                SMTP Settings</h3>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Smtp Server:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtSmtpServer" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvSmtp" runat="server" CssClass="error-1"
                                ErrorMessage="Smtp server Address is required" ControlToValidate="txtSmtpServer"
                                Display="Dynamic"></asp:RequiredFieldValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>Smtp Port:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtSmtpPort" runat="server" CssClass="textbox" Width="50px">25</asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvSmtpPort" runat="server" CssClass="error-1"
                                ErrorMessage="Smtp port is required" ControlToValidate="txtSmtpPort" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RangeValidator ID="rvSmtpPort" runat="server" CssClass="error-1" ControlToValidate="txtSmtpPort"
                                ErrorMessage="Smtp Port is invalid" MaximumValue="65535" MinimumValue="1" Type="Integer"></asp:RangeValidator>
                        </td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Security Mode:</td>
                        <td width="100%">
                            <asp:DropDownList ID="ddlSmtpSec" runat="server" CssClass="dropdown" Width="200px">
                                <asp:ListItem>Unsecure</asp:ListItem>
                                <asp:ListItem>Implicit</asp:ListItem>
                                <asp:ListItem>Explicit</asp:ListItem>
                            </asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Smtp User:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtSmtpUser" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Password:</td>
                        <td width="100%">
                            <asp:TextBox ID="txtSmtpPassword" runat="server" CssClass="textbox" Width="200px"
                                TextMode="Password"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            Authentication Method:</td>
                        <td width="100%">
                            <asp:DropDownList ID="ddlSmtpAuth" runat="server" CssClass="dropdown" Width="200px">
                            </asp:DropDownList></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>From Email:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtFrom" runat="server" CssClass="textbox" Width="200px" Text="admin@yourdomain.com"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvFrom" runat="server" CssClass="error-1"
                                ErrorMessage="From email is required" ControlToValidate="txtFrom" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="revFrom" runat="server" ControlToValidate="txtFrom"
                                CssClass="error-1" Display="Dynamic" ErrorMessage="From Email is invalid" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:RegularExpressionValidator></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                            <b>To Email:</b></td>
                        <td width="100%">
                            <asp:TextBox ID="txtTo" runat="server" CssClass="textbox" Width="200px"></asp:TextBox></td>
                    </tr>
                    <tr>
                        <td style="white-space: nowrap">
                        </td>
                        <td>
                            <asp:RequiredFieldValidator ID="rfvTo" runat="server" CssClass="error-1" ErrorMessage="To email is required"
                                ControlToValidate="txtTo" Display="Dynamic"></asp:RequiredFieldValidator>
                            <asp:RegularExpressionValidator ID="revTo" runat="server" ControlToValidate="txtTo"
                                CssClass="error-1" Display="Dynamic" ErrorMessage="To Email is invalid" ValidationExpression="\w+([-+.']\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*"></asp:RegularExpressionValidator></td>
                    </tr>
                    <tr>
                        <td colspan="2">
                            <asp:Label ID="lblResult" runat="server" CssClass="bodytext"></asp:Label></td>
                    </tr>
                    <tr>
                        <td></td><td>
                            <asp:Button CssClass="okbutton" ID="btnSmtpTest" runat="server" Text="Test SMTP"
                                OnClick="btnSmtp_Click" />&nbsp;<asp:Button CssClass="okbutton" ID="btnProcess" runat="server"
                                    Text="Process" OnClick="btnProcess_Click" /></td>
                    </tr>
                </table>
            </div>
        </div>
    </form>
</body>
</html>
